/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.naming;

import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.apache.servicemix.naming.InitialContextFactoryWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiInitialContextFactoryBuilder
implements InitialContextFactoryBuilder,
BundleContextAware,
InitializingBean,
DisposableBean {
    private BundleContext bundleContext;
    private Context osgiContext;
    private ServiceTracker tracker;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Context getOsgiContext() {
        return this.osgiContext;
    }

    public void setOsgiContext(Context osgiContext) {
        this.osgiContext = osgiContext;
    }

    public void afterPropertiesSet() throws NamingException {
        Assert.notNull((Object)this.bundleContext, (String)"Required 'bundleContext' property was not set.");
        Assert.notNull((Object)this.osgiContext, (String)"Required 'osgiContext' property was not set.");
        this.tracker = new ServiceTracker(this.bundleContext, InitialContextFactoryBuilder.class.getName(), null);
        this.tracker.open();
        NamingManager.setInitialContextFactoryBuilder(this);
    }

    public void destroy() {
        this.tracker.close();
        this.tracker = null;
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!InitialContextFactoryBuilder.class.equals(field.getType())) continue;
                field.setAccessible(true);
                field.set(null, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> env) throws NamingException {
        String className;
        if (this.tracker == null) {
            throw new IllegalStateException("OSGiInitialContextFactoryBuilder is not initialized");
        }
        InitialContextFactory factory = null;
        InitialContextFactoryBuilder factoryBuilder = (InitialContextFactoryBuilder)this.tracker.getService();
        if (factoryBuilder != null) {
            factory = factoryBuilder.createInitialContextFactory(env);
        }
        if (factory == null && env != null && (className = (String)env.get("java.naming.factory.initial")) != null) {
            try {
                factory = (InitialContextFactory)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + className);
                ne.setRootCause(e);
                throw ne;
            }
        }
        if (factory == null) {
            NoInitialContextException ne = new NoInitialContextException("Need to specify class name in environment or system property, or as an applet parameter, or in an application resource file:  java.naming.factory.initial");
            throw ne;
        }
        return new InitialContextFactoryWrapper(factory, this.osgiContext);
    }
}

