/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.osgi.jmx.compendium;

import java.io.IOException;
import org.osgi.jmx.compendium.PermissionManagerMBean;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionManager
implements PermissionManagerMBean {
    protected PermissionAdmin admin;

    public PermissionManager(PermissionAdmin admin) {
        this.admin = admin;
    }

    public String[] getLocations() throws IOException {
        return this.admin.getLocations();
    }

    public String[] getPermissions(String location) throws IOException {
        PermissionInfo[] permissions = this.admin.getPermissions(location);
        if (permissions == null) {
            return null;
        }
        String[] encodedPermissions = new String[permissions.length];
        int i = 0;
        for (PermissionInfo permission : permissions) {
            encodedPermissions[i++] = permission.getEncoded();
        }
        return encodedPermissions;
    }

    public void setDefaultPermissions(String[] encodedPermissions) throws IOException {
        PermissionInfo[] permissions = new PermissionInfo[encodedPermissions.length];
        int i = 0;
        for (String encodedPermission : encodedPermissions) {
            permissions[i] = new PermissionInfo(encodedPermission);
        }
        this.admin.setDefaultPermissions(permissions);
    }

    public void setPermissions(String location, String[] encodedPermissions) throws IOException {
        PermissionInfo[] permissions = new PermissionInfo[encodedPermissions.length];
        int i = 0;
        for (String encodedPermission : encodedPermissions) {
            permissions[i] = new PermissionInfo(encodedPermission);
        }
        this.admin.setPermissions(location, permissions);
    }
}

