/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.osgi.jmx.compendium;

import com.oracle.osgi.jmx.Monitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.jmx.codec.OSGiAuthorization;
import org.osgi.jmx.codec.OSGiGroup;
import org.osgi.jmx.codec.OSGiProperties;
import org.osgi.jmx.codec.OSGiRole;
import org.osgi.jmx.codec.OSGiUser;
import org.osgi.jmx.compendium.UserManagerMBean;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class UserManager
extends Monitor
implements UserManagerMBean {
    protected UserAdmin admin;

    public UserManager(UserAdmin admin) {
        this.admin = admin;
    }

    public void addCredential(String key, byte[] value, String username) throws IOException {
        User user;
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a User: " + username);
        }
        user.getCredentials().put(key, value);
    }

    public void addCredential(String key, String value, String username) throws IOException {
        User user;
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a User: " + username);
        }
        user.getCredentials().put(key, value);
    }

    public boolean addMember(String groupname, String rolename) throws IOException {
        Role group = this.admin.getRole(groupname);
        Role role = this.admin.getRole(rolename);
        return group.getType() == 2 && ((Group)group).addMember(role);
    }

    public void addProperty(String key, byte[] value, String rolename) throws IOException {
        this.admin.getRole(rolename).getProperties().put(key, value);
    }

    public void addProperty(String key, String value, String rolename) throws IOException {
        this.admin.getRole(rolename).getProperties().put(key, value);
    }

    public boolean addRequiredMember(String groupname, String rolename) throws IOException {
        Role group = this.admin.getRole(groupname);
        Role role = this.admin.getRole(rolename);
        return group.getType() == 2 && ((Group)group).addRequiredMember(role);
    }

    public void createGroup(String name) throws IOException {
        this.admin.createRole(name, 2);
    }

    public void createUser(String name) throws IOException {
        this.admin.createRole(name, 1);
    }

    public CompositeData getAuthorization(String u) throws IOException {
        User user;
        try {
            user = (User)this.admin.getRole(u);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a user: " + u);
        }
        try {
            return new OSGiAuthorization(this.admin.getAuthorization(user)).asCompositeData();
        }
        catch (OpenDataException e) {
            throw new IOException("Unable to create open data type: " + e);
        }
    }

    public TabularData getCredentials(String username) throws IOException {
        User user;
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a user: " + username);
        }
        return OSGiProperties.tableFrom((Dictionary)user.getCredentials());
    }

    public CompositeData getGroup(String groupname) throws IOException {
        Group group;
        try {
            group = (Group)this.admin.getRole(groupname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a group: " + groupname);
        }
        try {
            return new OSGiGroup(group).asCompositeData();
        }
        catch (OpenDataException e) {
            throw new IOException("Cannot encode open data for group: " + e);
        }
    }

    public String[] getGroups() throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Cannot use null filter, apparently: " + (Object)((Object)e));
        }
        ArrayList<String> groups = new ArrayList<String>();
        for (Role role : roles) {
            if (role.getType() != 2) continue;
            groups.add(role.getName());
        }
        return groups.toArray(new String[groups.size()]);
    }

    public String[] getGroups(String filter) throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Cannot use null filter, apparently: " + (Object)((Object)e));
        }
        ArrayList<String> groups = new ArrayList<String>();
        for (Role role : roles) {
            if (role.getType() != 2) continue;
            groups.add(role.getName());
        }
        return groups.toArray(new String[groups.size()]);
    }

    public String[] getImpliedRoles(String username) throws IOException {
        Role role = this.admin.getRole(username);
        if (role.getType() == 1 && role instanceof User) {
            return this.admin.getAuthorization((User)role).getRoles();
        }
        return new String[0];
    }

    public String[] getMembers(String groupname) throws IOException {
        Group group;
        try {
            group = (Group)this.admin.getRole(groupname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a group: " + groupname);
        }
        Role[] members = group.getMembers();
        if (members == null) {
            return new String[0];
        }
        String[] names = new String[members.length];
        for (int i = 0; i < members.length; ++i) {
            names[i] = members[i].getName();
        }
        return names;
    }

    public TabularData getProperties(String rolename) throws IOException {
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            return null;
        }
        return OSGiProperties.tableFrom((Dictionary)role.getProperties());
    }

    public String[] getRequiredMembers(String groupname) throws IOException {
        Group group;
        try {
            group = (Group)this.admin.getRole(groupname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a group: " + groupname);
        }
        Role[] members = group.getRequiredMembers();
        if (members == null) {
            return new String[0];
        }
        String[] names = new String[members.length];
        for (int i = 0; i < members.length; ++i) {
            names[i] = members[i].getName();
        }
        return names;
    }

    public CompositeData getRole(String name) throws IOException {
        Role role = this.admin.getRole(name);
        try {
            return role == null ? null : new OSGiRole(role).asCompositeData();
        }
        catch (OpenDataException e) {
            throw new IOException("Unable to create open data: " + e);
        }
    }

    public String[] getRoles() throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Cannot use null filter, apparently: " + (Object)((Object)e));
        }
        String[] result = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            result[i] = roles[i].getName();
        }
        return result;
    }

    public String[] getRoles(String filter) throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Invalid filter: " + (Object)((Object)e));
        }
        String[] result = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            result[i] = roles[i].getName();
        }
        return result;
    }

    public CompositeData getUser(String username) throws IOException {
        User user;
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a user: " + username);
        }
        try {
            return user == null ? null : new OSGiUser(user).asCompositeData();
        }
        catch (OpenDataException e) {
            throw new IOException("Unable to create open data: " + e);
        }
    }

    public String getUser(String key, String value) throws IOException {
        User user = this.admin.getUser(key, value);
        return user == null ? null : user.getName();
    }

    public String[] getUsers() throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Cannot use null filter, apparently: " + (Object)((Object)e));
        }
        ArrayList<String> groups = new ArrayList<String>();
        for (Role role : roles) {
            if (role.getType() != 1) continue;
            groups.add(role.getName());
        }
        return groups.toArray(new String[groups.size()]);
    }

    public String[] getUsers(String filter) throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Cannot use null filter, apparently: " + (Object)((Object)e));
        }
        ArrayList<String> groups = new ArrayList<String>();
        for (Role role : roles) {
            if (role.getType() != 1) continue;
            groups.add(role.getName());
        }
        return groups.toArray(new String[groups.size()]);
    }

    public void removeCredential(String key, String username) throws IOException {
        User user;
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a user: " + username);
        }
        if (user == null) {
            return;
        }
        user.getCredentials().remove(key);
    }

    public boolean removeMember(String groupname, String rolename) throws IOException {
        Group group;
        try {
            group = (Group)this.admin.getRole(groupname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a group: " + groupname);
        }
        if (group == null) {
            return false;
        }
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            return false;
        }
        return group.removeMember(role);
    }

    public void removeProperty(String key, String rolename) throws IOException {
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            return;
        }
        role.getProperties().remove(key);
    }

    public boolean removeRole(String name) throws IOException {
        return this.admin.removeRole(name);
    }

    protected void addListener() {
    }

    protected void removeListener() {
    }
}

