/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.osgi.jmx.core;

import com.oracle.osgi.jmx.Monitor;
import java.io.IOException;
import java.util.ArrayList;
import javax.management.Notification;
import javax.management.openmbean.TabularData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.codec.OSGiBundle;
import org.osgi.jmx.codec.OSGiBundleEvent;
import org.osgi.jmx.codec.Util;
import org.osgi.jmx.core.BundleStateMBean;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class BundleState
extends Monitor
implements BundleStateMBean {
    protected BundleListener bundleListener;
    protected BundleContext bc;
    protected StartLevel sl;
    protected PackageAdmin admin;

    public BundleState(BundleContext bc, StartLevel sl, PackageAdmin admin) {
        this.bc = bc;
        this.sl = sl;
        this.admin = admin;
    }

    public long[] getDependencies(long bundleIdentifier) throws IOException {
        return Util.getBundleDependencies((Bundle)this.bundle(bundleIdentifier), (PackageAdmin)this.admin);
    }

    public TabularData getBundles() throws IOException {
        try {
            ArrayList<OSGiBundle> bundles = new ArrayList<OSGiBundle>();
            for (Bundle bundle : this.bc.getBundles()) {
                bundles.add(new OSGiBundle(this.bc, this.admin, this.sl, bundle));
            }
            TabularData table = OSGiBundle.tableFrom(bundles);
            return table;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getExportedPackages(long bundleId) throws IOException {
        ExportedPackage[] packages = this.admin.getExportedPackages(this.bundle(bundleId));
        String[] ep = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            ep[i] = packages[i].getName() + ";" + packages[i].getVersion();
        }
        return ep;
    }

    public long[] getFragments(long bundleId) throws IOException {
        return Util.getBundleFragments((Bundle)this.bundle(bundleId), (PackageAdmin)this.admin);
    }

    public TabularData getHeaders(long bundleId) throws IOException {
        return OSGiBundle.headerTable((Bundle)this.bundle(bundleId));
    }

    public long[] getHosts(long fragment) throws IOException {
        return Util.bundleIds((Bundle[])this.admin.getHosts(this.bundle(fragment)));
    }

    public String[] getImportedPackages(long bundleId) throws IOException {
        return Util.getBundleImportedPackages((Bundle)this.bundle(bundleId), (BundleContext)this.bc, (PackageAdmin)this.admin);
    }

    public long getLastModified(long bundleId) throws IOException {
        return this.bundle(bundleId).getLastModified();
    }

    public long[] getRegisteredServices(long bundleId) throws IOException {
        return Util.serviceIds((ServiceReference[])this.bundle(bundleId).getRegisteredServices());
    }

    public long[] getRequiringBundles(long bundleIdentifier) throws IOException {
        return Util.getBundlesRequiring((Bundle)this.bundle(bundleIdentifier), (BundleContext)this.bc, (PackageAdmin)this.admin);
    }

    public long[] getServicesInUse(long bundleIdentifier) throws IOException {
        return Util.serviceIds((ServiceReference[])this.bundle(bundleIdentifier).getServicesInUse());
    }

    public int getStartLevel(long bundleId) throws IOException {
        return this.sl.getBundleStartLevel(this.bundle(bundleId));
    }

    public String getState(long bundleId) throws IOException {
        return Util.getBundleState((Bundle)this.bundle(bundleId));
    }

    public String getSymbolicName(long bundleId) throws IOException {
        return this.bundle(bundleId).getSymbolicName();
    }

    public boolean isPersistentlyStarted(long bundleId) throws IOException {
        return Util.isBundlePersistentlyStarted((Bundle)this.bundle(bundleId), (StartLevel)this.sl);
    }

    public boolean isFragment(long bundleId) throws IOException {
        return Util.isBundleFragment((Bundle)this.bundle(bundleId), (PackageAdmin)this.admin);
    }

    public boolean isRemovalPending(long bundleId) throws IOException {
        return Util.isRequiredBundleRemovalPending((Bundle)this.bundle(bundleId), (BundleContext)this.bc, (PackageAdmin)this.admin);
    }

    public boolean isRequired(long bundleId) throws IOException {
        return Util.isBundleRequired((Bundle)this.bundle(bundleId), (BundleContext)this.bc, (PackageAdmin)this.admin);
    }

    private Bundle bundle(long bundleId) {
        Bundle b = this.bc.getBundle(bundleId);
        if (b == null) {
            throw new IllegalArgumentException("Bundle with id: " + bundleId + " does not exist");
        }
        return b;
    }

    protected void addListener() {
        this.bundleListener = this.getBundleListener();
        this.bc.addBundleListener(this.bundleListener);
    }

    protected BundleListener getBundleListener() {
        return new BundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                Notification notification = new Notification("org.osgi.jmx.bundleEvent", BundleState.this.objectName, BundleState.this.sequenceNumber++);
                notification.setUserData(new OSGiBundleEvent(bundleEvent).asCompositeData());
                BundleState.this.sendNotification(notification);
            }
        };
    }

    protected void removeListener() {
        if (this.bundleListener != null) {
            this.bc.removeBundleListener(this.bundleListener);
        }
    }
}

