/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.osgi.jmx.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.management.openmbean.CompositeData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.jmx.codec.BundleBatchActionResult;
import org.osgi.jmx.codec.BundleBatchInstallResult;
import org.osgi.jmx.core.FrameworkMBean;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class Framework
implements FrameworkMBean {
    protected BundleContext bc;
    protected StartLevel sl;
    protected PackageAdmin admin;

    public Framework(BundleContext bc, PackageAdmin admin, StartLevel sl) {
        this.bc = bc;
        this.admin = admin;
        this.sl = sl;
    }

    public int getFrameworkStartLevel() throws IOException {
        return this.sl.getStartLevel();
    }

    public int getInitialBundleStartLevel() throws IOException {
        return this.sl.getInitialBundleStartLevel();
    }

    public long installBundle(String location) throws IOException {
        try {
            return this.bc.installBundle(location).getBundleId();
        }
        catch (BundleException e) {
            throw new IOException("Unable to install bundle: " + (Object)((Object)e));
        }
    }

    public long installBundle(String location, String url) throws IOException {
        InputStream is = null;
        try {
            is = new URL(url).openStream();
            long l = this.bc.installBundle(location, is).getBundleId();
            return l;
        }
        catch (BundleException e) {
            throw new IOException("Unable to install bundle: " + (Object)((Object)e));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public CompositeData installBundles(String[] locations) throws IOException {
        long[] ids = new long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            try {
                ids[i] = this.bc.installBundle(locations[i]).getBundleId();
                continue;
            }
            catch (BundleException e) {
                long[] completed = new long[i];
                System.arraycopy(ids, 0, i, 0, completed.length);
                String[] remaining = new String[locations.length - i];
                System.arraycopy(locations, i, remaining, 0, remaining.length);
                return new BundleBatchInstallResult(e.toString(), completed, locations[i], remaining).asCompositeData();
            }
        }
        return new BundleBatchInstallResult(ids).asCompositeData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeData installBundles(String[] locations, String[] urls) throws IOException {
        long[] ids = new long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            InputStream is = null;
            try {
                is = new URL(urls[i]).openStream();
                ids[i] = this.bc.installBundle(locations[i], is).getBundleId();
                continue;
            }
            catch (BundleException e) {
                long[] completed = new long[i];
                System.arraycopy(ids, 0, i, 0, completed.length);
                String[] remaining = new String[locations.length - i];
                System.arraycopy(locations, i, remaining, 0, remaining.length);
                CompositeData compositeData = new BundleBatchInstallResult(e.toString(), completed, locations[i], remaining).asCompositeData();
                return compositeData;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return new BundleBatchInstallResult(ids).asCompositeData();
    }

    public void refreshPackages(long bundleIdentifier) throws IOException {
        this.admin.refreshPackages(new Bundle[]{this.bundle(bundleIdentifier)});
    }

    public CompositeData refreshPackages(long[] bundleIdentifiers) throws IOException {
        Bundle[] bundles = new Bundle[bundleIdentifiers.length];
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                bundles[i] = this.bundle(bundleIdentifiers[i]);
                continue;
            }
            catch (Throwable e) {
                long[] completed = new long[i];
                System.arraycopy(completed, 0, i, 0, completed.length);
                long[] remaining = new long[bundleIdentifiers.length - i];
                System.arraycopy(bundleIdentifiers, i, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
        }
        this.admin.refreshPackages(bundles);
        return new BundleBatchActionResult().asCompositeData();
    }

    public boolean resolveBundle(long bundleIdentifier) throws IOException {
        return this.admin.resolveBundles(new Bundle[]{this.bundle(bundleIdentifier)});
    }

    public boolean resolveBundles(long[] bundleIdentifiers) throws IOException {
        Bundle[] bundles = new Bundle[bundleIdentifiers.length];
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            bundles[i] = this.bundle(bundleIdentifiers[i]);
        }
        return this.admin.resolveBundles(bundles);
    }

    public void restartFramework() throws IOException {
        try {
            this.bundle(0L).update();
        }
        catch (BundleException e) {
            throw new IOException("Unable to restart framework: " + (Object)((Object)e));
        }
    }

    public void setBundleStartLevel(long bundleIdentifier, int newlevel) throws IOException {
        this.sl.setBundleStartLevel(this.bundle(bundleIdentifier), newlevel);
    }

    public CompositeData setBundleStartLevels(long[] bundleIdentifiers, int[] newlevels) throws IOException {
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.sl.setBundleStartLevel(this.bundle(bundleIdentifiers[i]), newlevels[i]);
                continue;
            }
            catch (Throwable e) {
                long[] completed = new long[i];
                System.arraycopy(completed, 0, i, 0, completed.length);
                long[] remaining = new long[bundleIdentifiers.length - i];
                System.arraycopy(bundleIdentifiers, i, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void setFrameworkStartLevel(int newlevel) throws IOException {
        this.sl.setStartLevel(newlevel);
    }

    public void setInitialBundleStartLevel(int newlevel) throws IOException {
        this.sl.setInitialBundleStartLevel(newlevel);
    }

    public void shutdownFramework() throws IOException {
        try {
            this.bundle(0L).stop();
        }
        catch (Throwable be) {
            throw new IOException("Shutting down not implemented in this framework: " + be);
        }
    }

    public void startBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).start();
        }
        catch (Throwable e) {
            throw new IOException("Unable to start bundle: " + e);
        }
    }

    public CompositeData startBundles(long[] bundleIdentifiers) throws IOException {
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.bundle(bundleIdentifiers[i]).start();
                continue;
            }
            catch (Throwable e) {
                long[] completed = new long[i];
                System.arraycopy(completed, 0, i, 0, completed.length);
                long[] remaining = new long[bundleIdentifiers.length - i];
                System.arraycopy(bundleIdentifiers, i, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void stopBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).stop();
        }
        catch (Throwable e) {
            throw new IOException("Unable to stop bundle: " + e);
        }
    }

    public CompositeData stopBundles(long[] bundleIdentifiers) throws IOException {
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.bundle(bundleIdentifiers[i]).stop();
                continue;
            }
            catch (Throwable e) {
                long[] completed = new long[i];
                System.arraycopy(completed, 0, i, 0, completed.length);
                long[] remaining = new long[bundleIdentifiers.length - i];
                System.arraycopy(bundleIdentifiers, i, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void uninstallBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).uninstall();
        }
        catch (BundleException e) {
            throw new IOException("Unable to uninstall bundle: " + (Object)((Object)e));
        }
    }

    public CompositeData uninstallBundles(long[] bundleIdentifiers) throws IOException {
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.bundle(bundleIdentifiers[i]).uninstall();
                continue;
            }
            catch (Throwable e) {
                long[] completed = new long[i];
                System.arraycopy(completed, 0, i, 0, completed.length);
                long[] remaining = new long[bundleIdentifiers.length - i];
                System.arraycopy(bundleIdentifiers, i, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void updateBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).update();
        }
        catch (BundleException e) {
            throw new IOException("Unable to update bundle: " + (Object)((Object)e));
        }
    }

    public void updateBundle(long bundleIdentifier, String url) throws IOException {
        InputStream is = null;
        try {
            is = new URL(url).openStream();
            this.bundle(bundleIdentifier).update(is);
        }
        catch (BundleException e) {
            throw new IOException("Unable to update bundle: " + (Object)((Object)e));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public CompositeData updateBundles(long[] bundleIdentifiers) throws IOException {
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.bundle(bundleIdentifiers[i]).update();
                continue;
            }
            catch (Throwable e) {
                long[] completed = new long[i];
                System.arraycopy(completed, 0, i, 0, completed.length);
                long[] remaining = new long[bundleIdentifiers.length - i];
                System.arraycopy(bundleIdentifiers, i, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompositeData updateBundles(long[] bundleIdentifiers, String[] urls) throws IOException {
        int i = 0;
        while (i < bundleIdentifiers.length) {
            block13: {
                InputStream is = null;
                try {
                    is = new URL(urls[i]).openStream();
                    this.bundle(bundleIdentifiers[i]).update(is);
                    if (is == null) break block13;
                }
                catch (Throwable e) {
                    try {
                        long[] completed = new long[i];
                        System.arraycopy(bundleIdentifiers, 0, i, 0, completed.length);
                        long[] remaining = new long[bundleIdentifiers.length - i];
                        System.arraycopy(bundleIdentifiers, i, remaining, 0, remaining.length);
                        CompositeData compositeData = new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
                        return compositeData;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e2) {}
                        }
                    }
                }
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void updateFramework() throws IOException {
        try {
            this.bundle(0L).update();
        }
        catch (BundleException be) {
            throw new IOException("Update of the framework is not implemented: " + (Object)((Object)be));
        }
    }

    protected Bundle bundle(long bundleIdentifier) {
        Bundle b = this.bc.getBundle(bundleIdentifier);
        if (b == null) {
            throw new IllegalArgumentException("Bundle <" + bundleIdentifier + "> does not exist");
        }
        return b;
    }
}

