/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.osgi.jmx.core;

import java.io.IOException;
import java.util.ArrayList;
import javax.management.openmbean.TabularData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.jmx.codec.OSGiPackage;
import org.osgi.jmx.core.PackageStateMBean;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class PackageState
implements PackageStateMBean {
    protected BundleContext bc;
    protected PackageAdmin admin;

    public PackageState(BundleContext bc, PackageAdmin admin) {
        this.bc = bc;
        this.admin = admin;
    }

    public long getExportingBundle(String packageName, String version) throws IOException {
        Version v = Version.parseVersion((String)version);
        for (ExportedPackage pkg : this.admin.getExportedPackages(packageName)) {
            if (!pkg.getVersion().equals((Object)v)) continue;
            return pkg.getExportingBundle().getBundleId();
        }
        return -1L;
    }

    public long[] getImportingBundles(String packageName, String version) throws IOException {
        Version v = Version.parseVersion((String)version);
        for (ExportedPackage pkg : this.admin.getExportedPackages(packageName)) {
            if (!pkg.getVersion().equals((Object)v)) continue;
            Bundle[] bundles = pkg.getImportingBundles();
            long[] ids = new long[bundles.length];
            for (int i = 0; i < bundles.length; ++i) {
                ids[i] = bundles[i].getBundleId();
            }
            return ids;
        }
        return new long[0];
    }

    public TabularData getPackages() {
        try {
            ArrayList<OSGiPackage> packages = new ArrayList<OSGiPackage>();
            for (Bundle bundle : this.bc.getBundles()) {
                ExportedPackage[] pkgs = this.admin.getExportedPackages(bundle);
                if (pkgs == null) continue;
                for (ExportedPackage pkg : pkgs) {
                    packages.add(new OSGiPackage(pkg));
                }
            }
            return OSGiPackage.tableFrom(packages);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isRemovalPending(String packageName, String version) throws IOException {
        Version v = Version.parseVersion((String)version);
        for (ExportedPackage pkg : this.admin.getExportedPackages(packageName)) {
            if (!pkg.getVersion().equals((Object)v)) continue;
            return pkg.isRemovalPending();
        }
        return false;
    }
}

