/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.osgi.jmx.core;

import com.oracle.osgi.jmx.Monitor;
import java.io.IOException;
import java.util.ArrayList;
import javax.management.Notification;
import javax.management.openmbean.TabularData;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.codec.OSGiProperties;
import org.osgi.jmx.codec.OSGiService;
import org.osgi.jmx.codec.OSGiServiceEvent;
import org.osgi.jmx.core.ServiceStateMBean;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceState
extends Monitor
implements ServiceStateMBean {
    protected ServiceListener serviceListener;
    protected BundleContext bc;

    public ServiceState(BundleContext bc) {
        this.bc = bc;
    }

    public long getBundle(long serviceId) throws IOException {
        return this.ref(serviceId).getBundle().getBundleId();
    }

    public TabularData getProperties(long serviceId) throws IOException {
        return OSGiProperties.tableFrom((ServiceReference)this.ref(serviceId));
    }

    public String[] getServiceInterfaces(long serviceId) throws IOException {
        return (String[])this.ref(serviceId).getProperty("objectClass");
    }

    public TabularData getServices() {
        try {
            ArrayList<OSGiService> services = new ArrayList<OSGiService>();
            for (Bundle bundle : this.bc.getBundles()) {
                ServiceReference[] refs = bundle.getRegisteredServices();
                if (refs == null) continue;
                for (ServiceReference ref : refs) {
                    services.add(new OSGiService(ref));
                }
            }
            return OSGiService.tableFrom(services);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public long[] getUsingBundles(long serviceId) throws IOException {
        Bundle[] bundles = this.ref(serviceId).getUsingBundles();
        long[] ids = new long[bundles.length];
        for (int i = 0; i < bundles.length; ++i) {
            ids[i] = bundles[i].getBundleId();
        }
        return ids;
    }

    protected void addListener() {
        this.serviceListener = this.getServiceListener();
        this.bc.addServiceListener(this.serviceListener);
    }

    protected ServiceListener getServiceListener() {
        return new AllServiceListener(){

            public void serviceChanged(ServiceEvent serviceEvent) {
                Notification notification = new Notification("org.osgi.jmx.serviceEvent", ServiceState.this.objectName, ServiceState.this.sequenceNumber++);
                notification.setUserData(new OSGiServiceEvent(serviceEvent).asCompositeData());
                ServiceState.this.sendNotification(notification);
            }
        };
    }

    protected void removeListener() {
        if (this.serviceListener != null) {
            this.bc.removeServiceListener(this.serviceListener);
        }
    }

    protected ServiceReference ref(long serviceId) throws IOException {
        Filter filter;
        try {
            filter = this.bc.createFilter("(service.id=" + serviceId + ")");
        }
        catch (InvalidSyntaxException e) {
            throw new IOException("Invalid filter syntax: " + (Object)((Object)e));
        }
        ServiceTracker tracker = new ServiceTracker(this.bc, filter, null);
        tracker.open();
        ServiceReference serviceReference = tracker.getServiceReference();
        if (serviceReference == null) {
            throw new IllegalArgumentException("Service <" + serviceId + "> does not exist");
        }
        tracker.close();
        return serviceReference;
    }
}

