/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.commands;

import java.util.List;
import org.apache.servicemix.jbi.commands.JbiCommandSupport;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.SharedLibrary;

public class ListCommand
extends JbiCommandSupport {
    private static final int NAME_COL_LENGTH = 30;

    protected Object doExecute() throws Exception {
        List<ServiceAssembly> assemblies;
        List<Component> components;
        List<SharedLibrary> libraries = this.getSharedLibraries();
        if (libraries != null && !libraries.isEmpty()) {
            this.io.out.println("Shared Libraries");
            this.io.out.println("----------------");
            for (SharedLibrary library : libraries) {
                this.io.out.println(library.getName() + " - " + library.getVersion() + " - " + (library.getDescription() != null ? library.getDescription() : ""));
            }
            this.io.out.println();
        }
        if ((components = this.getComponents()) != null && !components.isEmpty()) {
            this.io.out.println("Components");
            this.io.out.println("----------");
            this.io.out.println("   State                  Name                  Description");
            for (Component component : components) {
                this.io.out.println("[" + this.getStateString(component.getCurrentState()) + "] [" + this.getNameString(component.getName(), 30) + "]     " + (component.getDescription() != null ? component.getDescription() : ""));
            }
            this.io.out.println();
        }
        if ((assemblies = this.getServiceAssemblies()) != null && !assemblies.isEmpty()) {
            this.io.out.println("Service Assemblies");
            this.io.out.println("------------------");
            this.io.out.println("   State                  Name                  Description");
            for (ServiceAssembly assembly : assemblies) {
                this.io.out.println("[" + this.getStateString(assembly.getCurrentState()) + "] [" + this.getNameString(assembly.getName(), 30) + "]     " + (assembly.getDescription() != null ? assembly.getDescription() : ""));
            }
            this.io.out.println();
        }
        return null;
    }

    private String getNameString(String name, int colLength) {
        String ret = name;
        for (int i = 0; i < colLength - name.length(); ++i) {
            ret = ret + " ";
        }
        return ret;
    }

    private String getStateString(String state) {
        if (state.equals("Shutdown")) {
            return "Shutdown";
        }
        if (state.equals("Started")) {
            return "Started ";
        }
        if (state.equals("Stopped")) {
            return "Stopped ";
        }
        return "Unknown ";
    }
}

