/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.features.management;

import java.util.List;
import org.apache.servicemix.kernel.gshell.features.Feature;
import org.apache.servicemix.kernel.gshell.features.FeaturesService;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Feature")
public class ManagedFeature {
    private Feature feature;
    private FeaturesService featuresService;
    private String id;

    public ManagedFeature(Feature feature, FeaturesService featuresService) {
        this.feature = feature;
        this.id = feature.getName() + "-" + feature.getVersion();
        this.featuresService = featuresService;
    }

    @ManagedAttribute
    public String getId() {
        return this.id;
    }

    @ManagedAttribute
    public String getName() {
        return this.feature.getName();
    }

    @ManagedAttribute
    public String getVersion() {
        return this.feature.getVersion();
    }

    @ManagedAttribute
    public List<Feature> getDependencies() {
        return this.feature.getDependencies();
    }

    @ManagedAttribute
    public List<String> getBundles() {
        return this.feature.getBundles();
    }

    @ManagedOperation
    public void uninstallFeature() throws Exception {
        this.featuresService.uninstallFeature(this.feature.getName(), this.feature.getVersion());
    }

    @ManagedOperation
    public void installFeature() throws Exception {
        this.featuresService.installFeature(this.feature.getName(), this.feature.getVersion());
    }
}

