/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.osgi;

import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.kernel.gshell.core.OsgiCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

public abstract class BundleCommand
extends OsgiCommandSupport {
    @Argument(required=true, index=0)
    long id;
    @Option(name="--force")
    boolean force;

    protected Object doExecute() throws Exception {
        Bundle bundle;
        block5: {
            int level;
            StartLevel sl;
            ServiceReference ref;
            bundle = this.getBundleContext().getBundle(this.id);
            if (bundle == null) {
                this.io.out.println("Bundle " + this.id + " not found");
                return CommandAction.Result.FAILURE;
            }
            if (!this.force && (ref = this.getBundleContext().getServiceReference(StartLevel.class.getName())) != null && (sl = (StartLevel)this.getService(StartLevel.class, ref)) != null && (level = sl.getBundleStartLevel(bundle)) < 50) {
                String str;
                do {
                    StringBuffer sb = new StringBuffer();
                    this.io.err.print("You are about to access a system bundle.  Do you want to continue (yes/no): ");
                    this.io.err.flush();
                    while (true) {
                        int c;
                        if ((c = this.io.in.read()) < 0) {
                            return CommandAction.Result.FAILURE;
                        }
                        this.io.err.print((char)c);
                        if (c == 13 || c == 10) break;
                        sb.append((char)c);
                    }
                    str = sb.toString();
                    if ("yes".equals(str)) break block5;
                } while (!"no".equals(str));
                return CommandAction.Result.FAILURE;
            }
        }
        this.doExecute(bundle);
        return CommandAction.Result.SUCCESS;
    }

    protected abstract void doExecute(Bundle var1) throws Exception;
}

