/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.osgi;

import org.apache.geronimo.gshell.clp.Argument;
import org.apache.servicemix.kernel.gshell.osgi.BundleCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

public class BundleLevel
extends BundleCommand {
    @Argument(required=false, index=1)
    Integer level;

    protected void doExecute(Bundle bundle) throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(StartLevel.class.getName());
        if (ref == null) {
            this.io.out.println("StartLevel service is unavailable.");
            return;
        }
        StartLevel sl = (StartLevel)this.getService(StartLevel.class, ref);
        if (sl == null) {
            this.io.out.println("StartLevel service is unavailable.");
            return;
        }
        if (this.level == null) {
            this.io.out.println("Level " + sl.getBundleStartLevel(bundle));
        } else if (this.level < 50 && sl.getBundleStartLevel(bundle) > 50) {
            String str;
            do {
                StringBuffer sb = new StringBuffer();
                this.io.err.println("You are about to designate bundle as a system bundle.  Do you want to continue (yes/no): ");
                this.io.err.flush();
                while (true) {
                    int c;
                    if ((c = this.io.in.read()) < 0) {
                        return;
                    }
                    this.io.err.println((char)c);
                    if (c == 13 || c == 10) break;
                    sb.append((char)c);
                }
                str = sb.toString();
                if (!"yes".equals(str)) continue;
                sl.setBundleStartLevel(bundle, this.level.intValue());
                break;
            } while (!"no".equals(str));
        } else {
            sl.setBundleStartLevel(bundle, this.level.intValue());
        }
    }
}

