/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.osgi;

import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.kernel.gshell.core.OsgiCommandSupport;
import org.apache.servicemix.kernel.gshell.osgi.SpringApplicationListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class ListBundles
extends OsgiCommandSupport {
    @Option(name="-l", description="Show locations")
    boolean showLoc;
    @Option(name="-s", description="Show symbolic name")
    boolean showSymbolic;
    @Option(name="-u", description="Show update")
    boolean showUpdate;
    private SpringApplicationListener springApplicationListener;

    public SpringApplicationListener getSpringApplicationListener() {
        return this.springApplicationListener;
    }

    public void setSpringApplicationListener(SpringApplicationListener springApplicationListener) {
        this.springApplicationListener = springApplicationListener;
    }

    protected Object doExecute() throws Exception {
        Bundle[] bundles;
        ServiceReference ref = this.getBundleContext().getServiceReference(StartLevel.class.getName());
        StartLevel sl = null;
        if (ref != null) {
            sl = (StartLevel)this.getBundleContext().getService(ref);
        }
        if (sl == null) {
            this.io.out.println("StartLevel service is unavailable.");
        }
        ServiceReference pkgref = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin admin = null;
        if (pkgref != null && (admin = (PackageAdmin)this.getBundleContext().getService(pkgref)) == null) {
            this.io.out.println("PackageAdmin service is unavailable.");
        }
        if ((bundles = this.getBundleContext().getBundles()) != null) {
            if (sl != null) {
                this.io.out.println("START LEVEL " + sl.getStartLevel());
            }
            String msg = " Name";
            if (this.showLoc) {
                msg = " Location";
            } else if (this.showSymbolic) {
                msg = " Symbolic name";
            } else if (this.showUpdate) {
                msg = " Update location";
            }
            String level = sl == null ? "" : "  Level ";
            this.io.out.println("   ID   State         Spring   " + level + msg);
            for (int i = 0; i < bundles.length; ++i) {
                int ii;
                String name = (String)bundles[i].getHeaders().get("Bundle-Name");
                name = name == null ? bundles[i].getSymbolicName() : name;
                String string = name = name == null ? bundles[i].getLocation() : name;
                if (this.showLoc) {
                    name = bundles[i].getLocation();
                } else if (this.showSymbolic) {
                    name = bundles[i].getSymbolicName();
                    name = name == null ? "<no symbolic name>" : name;
                } else if (this.showUpdate) {
                    name = (String)bundles[i].getHeaders().get("Bundle-UpdateLocation");
                    name = name == null ? bundles[i].getLocation() : name;
                }
                String version = (String)bundles[i].getHeaders().get("Bundle-Version");
                name = !this.showLoc && !this.showUpdate && version != null ? name + " (" + version + ")" : name;
                long l = bundles[i].getBundleId();
                String id = String.valueOf(l);
                level = sl == null ? "1" : String.valueOf(sl.getBundleStartLevel(bundles[i]));
                while (level.length() < 5) {
                    level = " " + level;
                }
                while (id.length() < 4) {
                    id = " " + id;
                }
                this.io.out.println("[" + id + "] [" + this.getStateString(bundles[i]) + "] [" + this.getSpringStateString(bundles[i]) + "] [" + level + "] " + name);
                if (admin == null) continue;
                Bundle[] fragments = admin.getFragments(bundles[i]);
                Bundle[] hosts = admin.getHosts(bundles[i]);
                if (fragments != null) {
                    this.io.out.print("                                       Fragments: ");
                    ii = 0;
                    for (Bundle fragment : fragments) {
                        this.io.out.print(fragment.getBundleId());
                        if (fragments.length <= 1 || ++ii >= fragments.length) continue;
                        this.io.out.print(",");
                    }
                    this.io.out.println();
                }
                if (hosts == null) continue;
                this.io.out.print("                                       Hosts: ");
                ii = 0;
                for (Bundle host : hosts) {
                    this.io.out.print(host.getBundleId());
                    if (hosts.length <= 1 || ++ii >= hosts.length) continue;
                    this.io.out.print(",");
                }
                this.io.out.println();
            }
        } else {
            this.io.out.println("There are no installed bundles.");
        }
        this.getBundleContext().ungetService(ref);
        this.getBundleContext().ungetService(pkgref);
        return CommandAction.Result.SUCCESS;
    }

    public String getStateString(Bundle bundle) {
        int state = bundle.getState();
        if (state == 32) {
            return "Active     ";
        }
        if (state == 2) {
            return "Installed  ";
        }
        if (state == 4) {
            return "Resolved   ";
        }
        if (state == 8) {
            return "Starting   ";
        }
        if (state == 16) {
            return "Stopping   ";
        }
        return "Unknown    ";
    }

    public String getSpringStateString(Bundle bundle) {
        SpringApplicationListener.SpringState state = this.springApplicationListener.getSpringState(bundle);
        if (state == SpringApplicationListener.SpringState.Waiting) {
            return "Waiting";
        }
        if (state == SpringApplicationListener.SpringState.Started) {
            return "Started";
        }
        if (state == SpringApplicationListener.SpringState.Failed) {
            return "Failed ";
        }
        return "       ";
    }
}

