/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.osgi;

import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.kernel.gshell.core.OsgiCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class RefreshBundle
extends OsgiCommandSupport {
    @Argument(required=false)
    Long id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (ref == null) {
            this.io.out.println("PackageAdmin service is unavailable.");
            return CommandAction.Result.FAILURE;
        }
        try {
            PackageAdmin pa = (PackageAdmin)this.getBundleContext().getService(ref);
            if (pa == null) {
                this.io.out.println("PackageAdmin service is unavailable.");
                CommandAction.Result result = CommandAction.Result.FAILURE;
                return result;
            }
            if (this.id == null) {
                pa.refreshPackages(null);
            } else {
                Bundle bundle = this.getBundleContext().getBundle(this.id.longValue());
                if (bundle == null) {
                    this.io.out.println("Bundle " + this.id + " not found");
                    CommandAction.Result result = CommandAction.Result.FAILURE;
                    return result;
                }
                pa.refreshPackages(new Bundle[]{bundle});
            }
        }
        finally {
            this.getBundleContext().ungetService(ref);
        }
        return CommandAction.Result.SUCCESS;
    }
}

