/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.osgi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextRefreshedEvent;
import org.springframework.osgi.extender.event.BootstrappingDependencyEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitStartingEvent;

public class SpringApplicationListener
implements OsgiBundleApplicationContextListener,
BundleListener,
BundleContextAware,
InitializingBean,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(SpringApplicationListener.class);
    private final Map<Long, SpringState> states = new ConcurrentHashMap<Long, SpringState>();
    private BundleContext bundleContext;

    public SpringState getSpringState(Bundle bundle) {
        SpringState state = this.states.get(bundle.getBundleId());
        if (state == null || bundle.getState() != 32) {
            state = SpringState.Unknown;
        }
        return state;
    }

    public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
        SpringState state = null;
        if (event instanceof BootstrappingDependencyEvent) {
            OsgiServiceDependencyEvent de = ((BootstrappingDependencyEvent)event).getDependencyEvent();
            if (de instanceof OsgiServiceDependencyWaitStartingEvent) {
                state = SpringState.Waiting;
            }
        } else if (event instanceof OsgiBundleContextFailedEvent) {
            state = SpringState.Failed;
        } else if (event instanceof OsgiBundleContextRefreshedEvent) {
            state = SpringState.Started;
        }
        if (state != null) {
            LOG.debug((Object)("Spring app state changed to " + (Object)((Object)state) + " for bundle " + event.getBundle().getBundleId()));
            this.states.put(event.getBundle().getBundleId(), state);
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.states.remove(event.getBundle().getBundleId());
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void destroy() throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpringState {
        Unknown,
        Waiting,
        Started,
        Failed;

    }
}

