/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config.internal.adapter;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.config.internal.adapter.CustomListenerAdapterUtils;
import org.springframework.osgi.config.internal.util.MethodUtils;
import org.springframework.osgi.service.exporter.OsgiServiceRegistrationListener;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class OsgiServiceRegistrationListenerAdapter
implements OsgiServiceRegistrationListener,
InitializingBean,
BeanFactoryAware {
    private static final Log log = LogFactory.getLog((Class)OsgiServiceRegistrationListenerAdapter.class);
    private boolean isListener;
    private String registrationMethod;
    private String unregistrationMethod;
    private Object target;
    private String targetBeanName;
    private BeanFactory beanFactory;
    private boolean initialized;
    private Map registrationMethods;
    private Map unregistrationMethods;
    static /* synthetic */ Class class$java$util$Dictionary;
    static /* synthetic */ Class class$java$util$Map;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.beanFactory);
        Assert.isTrue((this.target != null || StringUtils.hasText((String)this.targetBeanName) ? 1 : 0) != 0, (String)"one of 'target' or 'targetBeanName' properties has to be set");
        if (this.target != null) {
            this.initialized = true;
        }
        this.initialize();
    }

    private void retrieveTarget() {
        this.target = this.beanFactory.getBean(this.targetBeanName);
        this.initialized = true;
    }

    private void initialize() {
        Class clazz = this.target == null ? this.beanFactory.getType(this.targetBeanName) : this.target.getClass();
        this.isListener = OsgiServiceRegistrationListener.class.isAssignableFrom(clazz);
        if (this.isListener && log.isDebugEnabled()) {
            log.debug((Object)(clazz.getName() + " is a registration listener"));
        }
        this.registrationMethods = CustomListenerAdapterUtils.determineCustomMethods(clazz, this.registrationMethod);
        this.unregistrationMethods = CustomListenerAdapterUtils.determineCustomMethods(clazz, this.unregistrationMethod);
        if (!this.isListener && this.registrationMethods.isEmpty() && this.unregistrationMethods.isEmpty()) {
            throw new IllegalArgumentException("target object needs to implement " + OsgiServiceRegistrationListener.class.getName() + " or custom registered/unregistered methods have to be specified");
        }
    }

    protected Map determineCustomMethods(final String methodName) {
        if (!StringUtils.hasText((String)methodName)) {
            return Collections.EMPTY_MAP;
        }
        final LinkedHashMap methods = new LinkedHashMap(3);
        final boolean trace = log.isTraceEnabled();
        ReflectionUtils.doWithMethods(this.target.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Class<?>[] args;
                if (!MethodUtils.isBridge(method) && methodName.equals(method.getName()) && (args = method.getParameterTypes()) != null && args.length == 1) {
                    Method m;
                    Class<?> propType;
                    if (((class$java$util$Dictionary == null ? (class$java$util$Dictionary = OsgiServiceRegistrationListenerAdapter.class$("java.util.Dictionary")) : class$java$util$Dictionary).isAssignableFrom(propType = args[0]) || (class$java$util$Map == null ? (class$java$util$Map = OsgiServiceRegistrationListenerAdapter.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(propType)) && trace) {
                        log.trace((Object)("discovered custom method [" + method.toString() + "] on " + OsgiServiceRegistrationListenerAdapter.this.target.getClass()));
                    }
                    if ((m = (Method)methods.get(methodName)) != null) {
                        if (trace) {
                            log.trace((Object)("there is already a custom method [" + m.toString() + "];ignoring " + method));
                        }
                    } else {
                        ReflectionUtils.makeAccessible((Method)method);
                        methods.put(methodName, method);
                    }
                }
            }
        });
        if (!methods.isEmpty()) {
            return methods;
        }
        throw new IllegalArgumentException("incorrect custom method [" + methodName + "] specified on class " + this.target.getClass());
    }

    public void registered(Object service, Map serviceProperties) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("invoking registered method with props=" + serviceProperties));
        }
        if (!this.initialized) {
            this.retrieveTarget();
        }
        if (this.isListener) {
            if (trace) {
                log.trace((Object)"invoking listener interface methods");
            }
            try {
                ((OsgiServiceRegistrationListener)this.target).registered(service, serviceProperties);
            }
            catch (Exception ex) {
                log.warn((Object)("standard registered method on [" + this.target.getClass().getName() + "] threw exception"), (Throwable)ex);
            }
        }
        CustomListenerAdapterUtils.invokeCustomMethods(this.target, this.registrationMethods, service, serviceProperties);
    }

    public void unregistered(Object service, Map serviceProperties) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("invoking unregistered method with props=" + serviceProperties));
        }
        if (!this.initialized) {
            this.retrieveTarget();
        }
        if (this.isListener) {
            if (trace) {
                log.trace((Object)"invoking listener interface methods");
            }
            try {
                ((OsgiServiceRegistrationListener)this.target).unregistered(service, serviceProperties);
            }
            catch (Exception ex) {
                log.warn((Object)("standard unregistered method on [" + this.target.getClass().getName() + "] threw exception"), (Throwable)ex);
            }
        }
        CustomListenerAdapterUtils.invokeCustomMethods(this.target, this.unregistrationMethods, service, serviceProperties);
    }

    protected void invokeCustomMethods(Object target, Map methods, Map properties) {
        if (methods != null && !methods.isEmpty()) {
            boolean trace = log.isTraceEnabled();
            Object[] args = new Object[]{properties};
            Iterator iter = methods.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Method method = (Method)entry.getValue();
                if (trace) {
                    log.trace((Object)("invoking listener custom method " + method));
                }
                try {
                    org.springframework.osgi.util.internal.ReflectionUtils.invokeMethod(method, target, args);
                }
                catch (Exception ex) {
                    Exception cause = org.springframework.osgi.util.internal.ReflectionUtils.getInvocationException(ex);
                    log.warn((Object)("custom method [" + method + "] threw exception when passing properties [" + properties + "]"), (Throwable)cause);
                }
            }
        }
    }

    public void setRegistrationMethod(String registrationMethod) {
        this.registrationMethod = registrationMethod;
    }

    public void setUnregistrationMethod(String unregistrationMethod) {
        this.unregistrationMethod = unregistrationMethod;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }
}

