/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.internal.classloader;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.util.Assert;

public class ChainedClassLoader
extends ClassLoader {
    private final List loaders = new ArrayList();
    private int index = 0;
    private final ClassLoader systemClassLoader;

    public ChainedClassLoader(ClassLoader[] loaders) {
        Assert.notEmpty((Object[])loaders);
        for (int i = 0; i < loaders.length; ++i) {
            ClassLoader classLoader = loaders[i];
            Assert.notNull((Object)classLoader, (String)"null classloaders not allowed");
            this.loaders.add(classLoader);
        }
        this.systemClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(final String name) {
        List list = this.loaders;
        synchronized (list) {
            if (System.getSecurityManager() != null) {
                return (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ChainedClassLoader.this.doGetResource(name);
                    }
                });
            }
            return this.doGetResource(name);
        }
    }

    private URL doGetResource(String name) {
        URL url = null;
        for (int i = 0; i < this.loaders.size(); ++i) {
            ClassLoader loader = (ClassLoader)this.loaders.get(i);
            url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(final String name) throws ClassNotFoundException {
        List list = this.loaders;
        synchronized (list) {
            if (System.getSecurityManager() != null) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return ChainedClassLoader.this.doLoadClass(name);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (ClassNotFoundException)pae.getException();
                }
            }
            return this.doLoadClass(name);
        }
    }

    private Class doLoadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        for (int i = 0; i < this.loaders.size(); ++i) {
            ClassLoader loader = (ClassLoader)this.loaders.get(i);
            try {
                clazz = loader.loadClass(name);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
        }
        throw new ClassNotFoundException(name);
    }

    public void addClassLoader(final Class clazz) {
        this.addClassLoader((ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassUtils.getClassLoader(clazz);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassLoader(ClassLoader classLoader) {
        List list = this.loaders;
        synchronized (list) {
            if (!this.loaders.contains(classLoader)) {
                if (this.systemClassLoader.equals(classLoader)) {
                    this.loaders.add(classLoader);
                } else {
                    this.loaders.add(++this.index, classLoader);
                }
            }
        }
    }
}

