/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceReferenceProvider;
import org.springframework.util.Assert;

public abstract class ServiceInvoker
implements MethodInterceptor,
ServiceReferenceProvider,
DisposableBean {
    protected final transient Log log = LogFactory.getLog(this.getClass());

    protected Object doInvoke(Object service, MethodInvocation invocation) throws Throwable {
        Assert.notNull((Object)service, (String)"service should not be null!");
        Method method = invocation.getMethod();
        try {
            return method.invoke(service, invocation.getArguments());
        }
        catch (IllegalAccessException ex) {
            throw (RuntimeException)new IllegalAccessException("The invoked method [" + method.getName() + "] cannot be accessed. This usually occurs when proxying classes with final methods (which cannot be proxied). Consider using interfaces instead. If this is not an option, call only non-final methods.").initCause(ex);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        return this.doInvoke(this.getTarget(), invocation);
    }

    protected abstract Object getTarget();

    public ServiceReference getServiceReference() {
        return null;
    }

    public abstract void destroy();
}

