/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.support;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.util.Assert;

public class ServiceWrapper
implements Comparable {
    private ServiceReference reference;
    private final long serviceId;
    private final int serviceRanking;
    private final String toString;
    private BundleContext context;

    public ServiceWrapper(ServiceReference ref) {
        this(ref, OsgiBundleUtils.getBundleContext(ref.getBundle()));
    }

    public ServiceWrapper(ServiceReference ref, BundleContext bundleContext) {
        Assert.notNull((Object)ref, (String)"not null service reference required");
        Assert.notNull((Object)bundleContext, (String)"bundleContext required");
        this.reference = ref;
        this.context = bundleContext;
        this.serviceId = OsgiServiceReferenceUtils.getServiceId(ref);
        this.serviceRanking = OsgiServiceReferenceUtils.getServiceRanking(ref);
        this.toString = "ServiceWrapper[serviceId=" + this.serviceId + "|ref=" + this.reference + "]";
    }

    public ServiceWrapper(ServiceWrapper wrapper) {
        Assert.notNull((Object)wrapper);
        this.reference = wrapper.reference;
        this.serviceId = wrapper.serviceId;
        this.serviceRanking = wrapper.serviceRanking;
        this.toString = wrapper.toString;
        this.context = wrapper.context;
    }

    public boolean isServiceAlive() {
        return this.context != null && this.reference.getBundle() != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceWrapper) {
            return this.reference.equals(((ServiceWrapper)obj).reference);
        }
        return false;
    }

    public int hashCode() {
        return ServiceWrapper.class.hashCode() * 13 + (int)this.serviceId;
    }

    public String toString() {
        return this.toString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService() {
        if (this.isServiceAlive()) {
            Object object = this.context.getService(this.reference);
            return object;
        }
        return null;
    }

    public ServiceReference getReference() {
        return this.reference;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public int getServiceRanking() {
        return this.serviceRanking;
    }

    public void cleanup() {
        this.context = null;
    }

    public int compareTo(Object o) {
        return this.compareTo((ServiceWrapper)o);
    }

    public int compareTo(ServiceWrapper other) {
        return this.serviceId < other.serviceId ? -1 : (this.serviceId == other.serviceId ? 0 : 1);
    }
}

