/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.application.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.gshell.application.model.Branding;
import org.apache.geronimo.gshell.artifact.Artifact;
import org.apache.geronimo.gshell.yarn.Yarn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationModel {
    private String groupId;
    private String artifactId;
    private String version;
    private String name;
    private List<Artifact> dependencies;
    private List<Artifact> plugins;
    private Branding branding;

    public String toString() {
        return Yarn.render(this);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getId() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Artifact getArtifact() {
        Artifact artifact = new Artifact();
        artifact.setGroup(this.getGroupId());
        artifact.setName(this.getArtifactId());
        artifact.setVersion(this.getVersion());
        return artifact;
    }

    public List<Artifact> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Artifact>();
        }
        return this.dependencies;
    }

    public void setDependencies(List<Artifact> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(Artifact dependency) {
        assert (dependency != null);
        this.getDependencies().add(dependency);
    }

    public List<Artifact> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<Artifact>();
        }
        return this.plugins;
    }

    public void setPlugins(List<Artifact> plugins) {
        this.plugins = plugins;
    }

    public void addPlugin(Artifact plugin) {
        assert (plugin != null);
        this.getPlugins().add(plugin);
    }

    public Branding getBranding() {
        if (this.branding == null) {
            throw new IllegalStateException("Missing 'branding' configuration");
        }
        return this.branding;
    }

    public void setBranding(Branding branding) {
        this.branding = branding;
        branding.setParent(this);
    }
}

