/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.application.model;

import java.io.File;
import org.apache.geronimo.gshell.application.model.ApplicationModel;
import org.apache.geronimo.gshell.yarn.Yarn;

public class Branding {
    private transient ApplicationModel parent;
    private String programName;
    private String userDirectory;
    private String profileScriptName;
    private String historyFileName;
    private String interactiveScriptName;
    private String aboutMessage;
    private String welcomeMessage;
    private String prompt;

    public String toString() {
        return Yarn.render(this);
    }

    public ApplicationModel getParent() {
        if (this.parent == null) {
            throw new IllegalStateException("Not attached to parent");
        }
        return this.parent;
    }

    public void setParent(ApplicationModel parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.getParent().getArtifactId();
    }

    public String getProgramName() {
        if (this.programName == null) {
            return System.getProperty("gshell.program", this.getName());
        }
        return this.programName;
    }

    public String getUserDirectory() {
        if (this.userDirectory == null) {
            File userHome = new File(System.getProperty("user.home"));
            File dir = new File(userHome, "." + this.getName());
            return dir.getAbsolutePath();
        }
        return this.userDirectory;
    }

    public String getProfileScriptName() {
        if (this.profileScriptName == null) {
            return this.getName() + ".profile";
        }
        return this.profileScriptName;
    }

    public String getHistoryFileName() {
        if (this.historyFileName == null) {
            return this.getName() + ".history";
        }
        return this.historyFileName;
    }

    public File getHistoryFile() {
        return new File(this.getUserDirectory(), this.getHistoryFileName());
    }

    public String getInteractiveScriptName() {
        if (this.interactiveScriptName == null) {
            return this.getName() + ".rc";
        }
        return this.interactiveScriptName;
    }

    public String getAboutMessage() {
        return this.aboutMessage;
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String getPrompt() {
        return this.prompt;
    }
}

