/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.artifact.transfer;

import org.apache.geronimo.gshell.artifact.transfer.TransferEvent;
import org.apache.geronimo.gshell.artifact.transfer.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferListenerSupport
implements TransferListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public void transferStarted(TransferEvent event) {
        this.log.trace("Transfer started: {}", (Object)event);
    }

    public void transferProgress(TransferEvent event) {
        this.log.trace("Transfer progress: {}", (Object)event);
    }

    public void transferCompleted(TransferEvent event) {
        this.log.trace("Transfer completed: {}", (Object)event);
    }

    public void transferFailed(TransferEvent event) {
        this.log.trace("Transfer failure: {}", (Object)event);
    }

    protected String renderRequestType(TransferEvent event) {
        assert (event != null);
        return event.getRequestType() == TransferEvent.RequestType.UPLOAD ? "Uploading" : "Downloading";
    }

    protected String renderRequestTypeFinished(TransferEvent event) {
        assert (event != null);
        return event.getRequestType() == TransferEvent.RequestType.UPLOAD ? "Uploaded" : "Downloaded";
    }

    protected String renderProgressBytes(long length, long total) {
        if (total > 1024L) {
            return length / 1024L + "/" + (total == -1L ? "?" : total / 1024L + "K");
        }
        return length + "/" + (total == -1L ? "?" : total + "b");
    }

    protected String renderBytes(long length) {
        if (length > 1024L) {
            return length / 1024L + "K";
        }
        return length + "b";
    }
}

