/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.chronos;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.geronimo.gshell.yarn.Yarn;

public class Duration
implements Serializable {
    public static final TimeUnit DEFAULT_UNIT = TimeUnit.MILLISECONDS;
    public final long value;
    public final TimeUnit unit;

    public Duration(long value, TimeUnit unit) {
        this.value = value;
        this.unit = unit == null ? DEFAULT_UNIT : unit;
    }

    public Duration(long value) {
        this(value, DEFAULT_UNIT);
    }

    public long getValue() {
        return this.value;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public String toString() {
        return Yarn.render(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Duration duration = (Duration)obj;
        return this.value == duration.value && this.unit == duration.unit;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }
}

