/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.chronos;

import java.util.ArrayList;

class DurationFormatUtils {
    private static final Object y = "y";
    private static final Object M = "M";
    private static final Object d = "d";
    private static final Object H = "H";
    private static final Object m = "m";
    private static final Object s = "s";
    private static final Object S = "S";
    private static final long DateUtils_MILLIS_PER_SECOND = 1000L;
    private static final long DateUtils_MILLIS_PER_MINUTE = 60000L;
    private static final long DateUtils_MILLIS_PER_HOUR = 3600000L;
    private static final long DateUtils_MILLIS_PER_DAY = 86400000L;

    public static String formatDurationHMS(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, "H:mm:ss.SSS", true);
    }

    private static String formatDuration(long durationMillis, String format, boolean padWithZeros) {
        Token[] tokens = DurationFormatUtils.lexx(format);
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int milliseconds = 0;
        if (Token.containsTokenWithValue(tokens, d)) {
            days = (int)(durationMillis / 86400000L);
            durationMillis -= (long)days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, H)) {
            hours = (int)(durationMillis / 3600000L);
            durationMillis -= (long)hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, m)) {
            minutes = (int)(durationMillis / 60000L);
            durationMillis -= (long)minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, s)) {
            seconds = (int)(durationMillis / 1000L);
            durationMillis -= (long)seconds * 1000L;
        }
        if (Token.containsTokenWithValue(tokens, S)) {
            milliseconds = (int)durationMillis;
        }
        return DurationFormatUtils.format(tokens, 0, 0, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    private static String format(Token[] tokens, int years, int months, int days, int hours, int minutes, int seconds, int milliseconds, boolean padWithZeros) {
        StringBuilder buffer = new StringBuilder();
        boolean lastOutputSeconds = false;
        for (Token token : tokens) {
            Object value = token.getValue();
            int count = token.getCount();
            if (value instanceof StringBuilder) {
                buffer.append(value.toString());
                continue;
            }
            if (value == y) {
                buffer.append(padWithZeros ? DurationFormatUtils.leftPad(Integer.toString(years), count, "0") : Integer.toString(years));
                lastOutputSeconds = false;
                continue;
            }
            if (value == M) {
                buffer.append(padWithZeros ? DurationFormatUtils.leftPad(Integer.toString(months), count, "0") : Integer.toString(months));
                lastOutputSeconds = false;
                continue;
            }
            if (value == d) {
                buffer.append(padWithZeros ? DurationFormatUtils.leftPad(Integer.toString(days), count, "0") : Integer.toString(days));
                lastOutputSeconds = false;
                continue;
            }
            if (value == H) {
                buffer.append(padWithZeros ? DurationFormatUtils.leftPad(Integer.toString(hours), count, "0") : Integer.toString(hours));
                lastOutputSeconds = false;
                continue;
            }
            if (value == m) {
                buffer.append(padWithZeros ? DurationFormatUtils.leftPad(Integer.toString(minutes), count, "0") : Integer.toString(minutes));
                lastOutputSeconds = false;
                continue;
            }
            if (value == s) {
                buffer.append(padWithZeros ? DurationFormatUtils.leftPad(Integer.toString(seconds), count, "0") : Integer.toString(seconds));
                lastOutputSeconds = true;
                continue;
            }
            if (value != S) continue;
            if (lastOutputSeconds) {
                String str = padWithZeros ? DurationFormatUtils.leftPad(Integer.toString(milliseconds), count, "0") : Integer.toString(milliseconds += 1000);
                buffer.append(str.substring(1));
            } else {
                buffer.append(padWithZeros ? DurationFormatUtils.leftPad(Integer.toString(milliseconds), count, "0") : Integer.toString(milliseconds));
            }
            lastOutputSeconds = false;
        }
        return buffer.toString();
    }

    private static Token[] lexx(String format) {
        char[] array = format.toCharArray();
        ArrayList<Token> list = new ArrayList<Token>(array.length);
        boolean inLiteral = false;
        StringBuilder buffer = null;
        Token previous = null;
        for (char ch : array) {
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            Object value = null;
            switch (ch) {
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuilder();
                    list.add(new Token(buffer));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value = y;
                    break;
                }
                case 'M': {
                    value = M;
                    break;
                }
                case 'd': {
                    value = d;
                    break;
                }
                case 'H': {
                    value = H;
                    break;
                }
                case 'm': {
                    value = m;
                    break;
                }
                case 's': {
                    value = s;
                    break;
                }
                case 'S': {
                    value = S;
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                        list.add(new Token(buffer));
                    }
                    buffer.append(ch);
                }
            }
            if (value == null) continue;
            if (previous != null && previous.getValue() == value) {
                previous.increment();
            } else {
                Token token = new Token(value);
                list.add(token);
                previous = token;
            }
            buffer = null;
        }
        return list.toArray(new Token[list.size()]);
    }

    private static String repeat(String str, int repeat) {
        StringBuilder buffer = new StringBuilder(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private static String leftPad(String str, int size, String delim) {
        if ((size = (size - str.length()) / delim.length()) > 0) {
            str = DurationFormatUtils.repeat(delim, size) + str;
        }
        return str;
    }

    private static class Token {
        private Object value;
        private int count;

        static boolean containsTokenWithValue(Token[] tokens, Object value) {
            int sz = tokens.length;
            for (int i = 0; i < sz; ++i) {
                if (tokens[i].getValue() != value) continue;
                return true;
            }
            return false;
        }

        Token(Object value) {
            this.value = value;
            this.count = 1;
        }

        Token(Object value, int count) {
            this.value = value;
            this.count = count;
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                Token tok2 = (Token)obj2;
                if (this.value.getClass() != tok2.value.getClass()) {
                    return false;
                }
                if (this.count != tok2.count) {
                    return false;
                }
                if (this.value instanceof StringBuilder) {
                    return this.value.toString().equals(tok2.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(tok2.value);
                }
                return this.value == tok2.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return DurationFormatUtils.repeat(this.value.toString(), this.count);
        }
    }
}

