/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.command;

import org.apache.geronimo.gshell.notification.Notification;
import org.apache.geronimo.gshell.yarn.Yarn;

public class CommandResult {
    private final Object value;
    private final Throwable failure;
    private final Notification notification;

    private CommandResult(Object value, Throwable failure, Notification notification) {
        this.value = value;
        this.failure = failure;
        this.notification = notification;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasFailed() {
        return this.failure != null;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public boolean hasNotified() {
        return this.notification != null;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public String toString() {
        return Yarn.render(this);
    }

    public static class NotificationResult
    extends CommandResult {
        public NotificationResult(Notification notification) {
            super(null, null, notification);
        }
    }

    public static class FailureResult
    extends CommandResult {
        public FailureResult(Throwable failure) {
            super(null, failure, null);
        }
    }

    public static class ValueResult
    extends CommandResult {
        public ValueResult(Object value) {
            super(value, null, null);
        }
    }
}

