/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtin;

import java.util.Collection;
import org.apache.geronimo.gshell.ansi.AnsiCode;
import org.apache.geronimo.gshell.ansi.AnsiRenderer;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.command.CommandDocumenter;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.registry.CommandResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpAction
implements CommandAction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CommandResolver commandResolver;
    @Argument
    private String commandName;

    public HelpAction(CommandResolver commandResolver) {
        assert (commandResolver != null);
        this.commandResolver = commandResolver;
    }

    @Override
    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        Collection<Command> commands = this.commandResolver.resolveCommands(this.commandName, context.getVariables());
        if (commands.isEmpty()) {
            io.out.print("Command ");
            io.out.print(AnsiRenderer.encode(this.commandName, AnsiCode.BOLD));
            io.out.println(" not found.");
            io.out.print("Try ");
            io.out.print(AnsiRenderer.encode("help", AnsiCode.BOLD));
            io.out.println(" for a list of available commands.");
            return CommandAction.Result.FAILURE;
        }
        if (commands.size() == 1) {
            Command command = commands.iterator().next();
            command.getDocumenter().renderManual(io.out);
            return CommandAction.Result.SUCCESS;
        }
        return this.displayAvailableCommands(context, commands);
    }

    private Object displayAvailableCommands(CommandContext context, Collection<Command> commands) throws Exception {
        assert (context != null);
        assert (commands != null);
        this.log.debug("Listing brief help for commands");
        int maxNameLen = 0;
        for (Command command : commands) {
            int len = command.getLocation().getName().length();
            maxNameLen = Math.max(len, maxNameLen);
        }
        IO io = context.getIo();
        io.out.println("Available commands:");
        for (Command command : commands) {
            CommandDocumenter documenter = command.getDocumenter();
            String formattedName = String.format("%-" + maxNameLen + "s", command.getLocation().getName());
            String desc = documenter.getDescription();
            io.out.print("  ");
            io.out.print(AnsiRenderer.encode(formattedName, AnsiCode.BOLD));
            if (desc != null) {
                io.out.print("  ");
                io.out.println(desc);
                continue;
            }
            io.out.println();
        }
        return CommandAction.Result.SUCCESS;
    }
}

