/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtin;

import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.registry.AliasRegistry;
import org.apache.geronimo.gshell.registry.NoSuchAliasException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnaliasAction
implements CommandAction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AliasRegistry aliasRegistry;
    @Argument(index=0, required=true)
    private String name;

    public UnaliasAction(AliasRegistry aliasRegistry) {
        assert (aliasRegistry != null);
        this.aliasRegistry = aliasRegistry;
    }

    public Object execute(CommandContext context) {
        assert (context != null);
        IO io = context.getIo();
        this.log.debug("Undefining alias: {}", (Object)this.name);
        try {
            this.aliasRegistry.removeAlias(this.name);
            return CommandAction.Result.SUCCESS;
        }
        catch (NoSuchAliasException e) {
            io.error("No alias defined: {}", this.name);
            return CommandAction.Result.FAILURE;
        }
    }
}

