/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.shell;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.util.Os;
import org.apache.commons.vfs.util.OsFamily;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.support.VfsActionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditAction
extends VfsActionSupport {
    @Option(name="-e", aliases={"--editor"})
    private String editor;
    @Argument(required=true)
    private String path;

    @Override
    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        FileObject file = this.resolveFile(context, this.path);
        this.ensureFileExists(file);
        this.ensureFileHasContent(file);
        this.ensureFileIsReadable(file);
        this.ensureFileIsWritable(file);
        FileObject tmp = file;
        if (!this.getFileSystemAccess().isLocalFile(file)) {
            tmp = this.resolveFile(context, "tmp:/gshell-edit-" + System.currentTimeMillis() + ".txt");
            this.log.debug("Using temporary file: {} ({})", (Object)tmp, tmp.getClass());
            tmp.createFile();
            tmp.copyFrom(file, Selectors.SELECT_SELF);
        }
        File localFile = this.getFileSystemAccess().getLocalFile(tmp);
        Object result = this.edit(context, localFile);
        if (tmp != file) {
            this.log.debug("Updating original file with edited content");
            file.copyFrom(tmp, Selectors.SELECT_SELF);
            tmp.delete();
            FileObjects.close(tmp);
        }
        FileObjects.close(file);
        return result;
    }

    private Object edit(CommandContext context, File localFile) throws Exception {
        assert (context != null);
        assert (localFile != null);
        this.log.debug("Editing file: {}", (Object)localFile);
        List<String> editorCmd = this.selectEditor();
        this.log.debug("Executing: {} {}", editorCmd, (Object)localFile);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        for (String s : editorCmd) {
            builder.command().add(s);
        }
        builder.command().add(localFile.getAbsolutePath());
        Process p = builder.start();
        this.log.debug("Waiting for process to exit...");
        int status = p.waitFor();
        this.log.info("Process exited w/status: {}", (Object)status);
        return status;
    }

    private List<String> selectEditor() {
        String cmd = this.editor != null ? this.editor : this.getDefaultEditor();
        return Arrays.asList(cmd.split("\\s"));
    }

    private String getDefaultEditor() {
        if (Os.isFamily((OsFamily)Os.OS_FAMILY_WINDOWS)) {
            return "NOTEPAD";
        }
        if (Os.isFamily((OsFamily)Os.OS_FAMILY_UNIX)) {
            String tmp;
            if (System.getenv("DISPLAY") != null && (tmp = System.getenv("XEDITOR")) != null) {
                return tmp;
            }
            tmp = System.getenv("EDITOR");
            if (tmp != null) {
                return tmp;
            }
        }
        throw new RuntimeException("Unable to determine the default editor command");
    }
}

