/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.shell;

import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.io.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAction
implements CommandAction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Argument(required=true)
    private List<String> args;

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        ProcessBuilder builder = new ProcessBuilder(this.args);
        this.log.info("Executing: {}", builder.command());
        Process p = builder.start();
        PumpStreamHandler handler = new PumpStreamHandler(io.inputStream, io.outputStream, io.errorStream);
        handler.attach(p);
        handler.start();
        this.log.debug("Waiting for process to exit...");
        int status = p.waitFor();
        this.log.info("Process exited w/status: {}", (Object)status);
        handler.stop();
        return status;
    }
}

