/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.shell;

import java.net.URI;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.selector.AggregateFileSelector;
import org.apache.geronimo.gshell.vfs.support.VfsActionSupport;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Matcher;

public class FindAction
extends VfsActionSupport {
    private final AggregateFileSelector selector = new AggregateFileSelector();
    @Argument(required=true)
    private String path;

    @Option(name="-name")
    private void addNameFilter(String name) throws MalformedPatternException {
        this.log.debug("Adding -name selector for: {}", (Object)name);
        this.selector.getSelectors().add(new NameSelector(name));
    }

    @Option(name="-iname")
    private void addiNameFilter(String name) throws MalformedPatternException {
        this.log.debug("Adding -iname selector for: {}", (Object)name);
        this.selector.getSelectors().add(new NameSelector(name, true));
    }

    @Option(name="-type")
    private void addTypeFilter(Type type) {
        this.log.debug("Adding -type selector for: {}", (Object)type);
        this.selector.getSelectors().add(new TypeSelector(type));
    }

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        FileObject root = this.resolveFile(context, this.path);
        this.ensureFileExists(root);
        this.find(context, root, this.selector);
        FileObjects.close(root);
        return CommandAction.Result.SUCCESS;
    }

    private void find(CommandContext context, FileObject file, FileSelector selector) throws FileSystemException {
        assert (context != null);
        assert (file != null);
        assert (selector != null);
        FileObject[] files = file.findFiles(selector);
        if (files != null && files.length != 0) {
            for (FileObject child : files) {
                this.display(context, child, file);
            }
        }
    }

    private void display(CommandContext context, FileObject file, FileObject root) throws FileSystemException {
        String path;
        assert (context != null);
        assert (file != null);
        try {
            path = new URI(this.path).resolve(root.getURL().toURI().relativize(file.getURL().toURI())).toString();
        }
        catch (Exception e) {
            path = file.getName().getPath();
        }
        IO io = context.getIo();
        io.info(path);
    }

    private class NameSelector
    implements FileSelector {
        private final Pattern pattern;
        private final PatternMatcher matcher;

        public NameSelector(String name, boolean ignoreCase) throws MalformedPatternException {
            assert (name != null);
            GlobCompiler compiler = new GlobCompiler();
            int options = ignoreCase ? 1 : 0;
            this.pattern = compiler.compile(name, options);
            this.matcher = new Perl5Matcher();
            FindAction.this.log.trace("Pattern: {}", (Object)this.pattern.getPattern());
        }

        public NameSelector(String name) throws MalformedPatternException {
            this(name, false);
        }

        public boolean includeFile(FileSelectInfo selection) throws Exception {
            assert (selection != null);
            return this.matcher.matches(selection.getFile().getName().getBaseName(), this.pattern);
        }

        public boolean traverseDescendents(FileSelectInfo selection) throws Exception {
            return true;
        }
    }

    private class TypeSelector
    implements FileSelector {
        private final Type type;

        public TypeSelector(Type type) {
            assert (type != null);
            this.type = type;
            FindAction.this.log.trace("Type: {}", (Object)type);
        }

        public boolean includeFile(FileSelectInfo selection) throws Exception {
            assert (selection != null);
            FileType ftype = selection.getFile().getType();
            switch (this.type) {
                case D: {
                    return ftype == FileType.FOLDER;
                }
                case F: {
                    return ftype == FileType.FILE;
                }
            }
            return false;
        }

        public boolean traverseDescendents(FileSelectInfo selection) throws Exception {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        F,
        D;

    }
}

