/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.shell;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.Arguments;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaAction
implements CommandAction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-m", aliases={"--method"})
    private String methodName = "main";
    @Argument(index=0, required=true)
    private String className;
    @Argument(index=1)
    private List<String> args;

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        this.log.debug("Loading class: {}", (Object)this.className);
        Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(this.className);
        this.log.info("Using type: {}", type);
        this.log.debug("Locating method: {}", (Object)this.methodName);
        Method method = type.getMethod(this.methodName, String[].class);
        this.log.info("Using method: {}", (Object)method);
        this.log.info("Invoking w/arguments: {}", (Object)Arguments.asString(this.args));
        Object result = method.invoke(null, this.args);
        this.log.info("Result: {}", result);
        return result;
    }
}

