/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.ssh;

import org.apache.sshd.server.PasswordAuthenticator;
import org.jsecurity.SecurityUtils;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.UsernamePasswordToken;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSecurityPasswordAuthenticator
implements PasswordAuthenticator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SecurityManager securityManager;

    public JSecurityPasswordAuthenticator(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public JSecurityPasswordAuthenticator() {
        this(null);
    }

    public Object authenticate(String username, String password) {
        assert (username != null);
        assert (password != null);
        this.log.debug("Authenticating: {}/{}", (Object)username, (Object)password);
        Subject currentUser = this.securityManager != null ? this.securityManager.getSubject() : SecurityUtils.getSubject();
        if (currentUser.isAuthenticated()) {
            this.log.debug("Logging out current user: {}", currentUser.getPrincipal());
            currentUser.logout();
        }
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password);
            currentUser.login((AuthenticationToken)token);
            Object principal = currentUser.getPrincipal();
            this.log.info("User [{}] logged in successfully", principal);
            return principal;
        }
        catch (AuthenticationException e) {
            this.log.error("Authentication failed: " + (Object)((Object)e), (Throwable)e);
            return null;
        }
    }
}

