/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import jline.Completor;
import jline.History;
import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.commandline.CommandLineExecutor;
import org.apache.geronimo.gshell.console.Console;
import org.apache.geronimo.gshell.console.JLineConsole;
import org.apache.geronimo.gshell.console.completer.AggregateCompleter;
import org.apache.geronimo.gshell.io.Closer;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.notification.ExitNotification;
import org.apache.geronimo.gshell.shell.Shell;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.apache.sshd.server.ShellFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellFactoryImpl
implements ShellFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Application application;
    private Console.Prompter prompter;
    private CommandLineExecutor executor;
    private History history;
    private List<Completor> completers;
    private Console.ErrorHandler errorHandler;

    public Console.Prompter getPrompter() {
        return this.prompter;
    }

    public void setPrompter(Console.Prompter prompter) {
        this.prompter = prompter;
    }

    public CommandLineExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(CommandLineExecutor executor) {
        this.executor = executor;
    }

    public History getHistory() {
        return this.history;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public List<Completor> getCompleters() {
        return this.completers;
    }

    public void setCompleters(List<Completor> completers) {
        this.completers = completers;
    }

    public Console.ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(Console.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ShellFactory.Shell createShell() {
        return new ShellImpl();
    }

    public class ShellImpl
    implements ShellFactory.Shell,
    Shell,
    ShellContext,
    Runnable {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ShellFactory.ExitCallback callback;
        private IO io;
        private Variables variables;
        private boolean closed;

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ShellFactory.ExitCallback callback) {
            this.callback = callback;
        }

        public void start(ShellFactory.Environment env) throws IOException {
            this.io = new IO(this.in, this.out, this.err, false);
            this.variables = new Variables(ShellFactoryImpl.this.application.getVariables());
            if (env != null) {
                for (Map.Entry entry : env.getEnv().entrySet()) {
                    this.variables.set((String)entry.getKey(), entry.getValue());
                }
            }
            this.variables.set("gshell.prompt", ShellFactoryImpl.this.application.getModel().getBranding().getPrompt());
            this.variables.set("gshell.group", "/");
            this.variables.set("gshell.username", env.getEnv().get("USER"));
            this.variables.set("gshell.hostname", ShellFactoryImpl.this.application.getLocalHost());
            this.variables.set("gshell.internal.history", ShellFactoryImpl.this.getHistory(), true);
            new Thread(this).start();
        }

        public void destroy() {
            this.close();
        }

        public ShellContext getContext() {
            return this;
        }

        public Object execute(String line) throws Exception {
            return ShellFactoryImpl.this.executor.execute(this.getContext(), line);
        }

        public Object execute(String command, Object[] args) throws Exception {
            return ShellFactoryImpl.this.executor.execute(this.getContext(), args);
        }

        public Object execute(Object ... args) throws Exception {
            return ShellFactoryImpl.this.executor.execute(this.getContext(), args);
        }

        public boolean isOpened() {
            return !this.closed;
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                Closer.close(this.in, this.out, this.err);
                this.callback.onExit(0);
            }
        }

        public boolean isInteractive() {
            return false;
        }

        public void run(Object ... args) throws Exception {
            Console.Executor executor = new Console.Executor(){

                public Console.Executor.Result execute(String line) throws Exception {
                    assert (line != null);
                    try {
                        ShellImpl.this.execute(line);
                    }
                    catch (ExitNotification n) {
                        return Console.Executor.Result.STOP;
                    }
                    return Console.Executor.Result.CONTINUE;
                }
            };
            IO io = this.getContext().getIo();
            JLineConsole console = new JLineConsole(executor, io);
            console.setPrompter(ShellFactoryImpl.this.getPrompter());
            console.setErrorHandler(ShellFactoryImpl.this.getErrorHandler());
            console.setHistory(ShellFactoryImpl.this.getHistory());
            if (ShellFactoryImpl.this.completers != null) {
                console.addCompleter(new AggregateCompleter(ShellFactoryImpl.this.completers));
            }
            console.run();
        }

        public Shell getShell() {
            return this;
        }

        public IO getIo() {
            return this.io;
        }

        public Variables getVariables() {
            return this.variables;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ShellContext ctx = ShellContextHolder.get(true);
            try {
                ShellContextHolder.set(this.getContext());
                this.run(new Object[0]);
            }
            catch (Exception e) {
                ShellFactoryImpl.this.log.error("Unhandled failure: " + e, (Throwable)e);
            }
            finally {
                ShellContextHolder.set(ctx);
                this.close();
            }
        }
    }
}

