/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.ssh;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.io.PromptReader;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.apache.geronimo.gshell.spring.BeanContainerAware;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.apache.sshd.common.util.NoCloseOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAction
implements CommandAction,
BeanContainerAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-l", aliases={"--username"})
    private String username;
    @Option(name="-P", aliases={"--password"})
    private String password;
    @Argument(required=true)
    private String hostname;
    @Option(name="-p", aliases={"--port"})
    private int port = 22;
    private BeanContainer container;
    private ClientSession session;

    public void setBeanContainer(BeanContainer container) {
        assert (container != null);
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        MessageSource messages = context.getCommand().getMessages();
        io.info(messages.format("info.connecting", this.hostname, this.port));
        if (this.username == null || this.password == null) {
            String text;
            PromptReader prompter = new PromptReader(io);
            this.log.debug("Prompting user for credentials");
            if (this.username == null) {
                text = messages.getMessage("prompt.username");
                this.username = prompter.readLine(text + ": ", new UsernamePasswordValidator(text));
            }
            if (this.password == null) {
                text = messages.getMessage("prompt.password");
                this.password = prompter.readPassword(text + ": ", new UsernamePasswordValidator(text));
            }
        }
        SshClient client = this.container.getBean(SshClient.class);
        this.log.debug("Created client: {}", (Object)client);
        client.start();
        try {
            ConnectFuture future = client.connect(this.hostname, this.port);
            future.await();
            this.session = future.getSession();
            try {
                io.info(messages.getMessage("info.connected"));
                this.session.authPassword(this.username, this.password);
                int ret = this.session.waitFor(14, 0L);
                if ((ret & 8) == 0) {
                    io.err.println("Authentication failed");
                    CommandAction.Result result = CommandAction.Result.FAILURE;
                    return result;
                }
                ClientChannel channel = this.session.createChannel("shell");
                channel.setIn((InputStream)new NoCloseInputStream(io.inputStream));
                channel.setOut((OutputStream)new NoCloseOutputStream((OutputStream)io.outputStream));
                channel.setErr((OutputStream)new NoCloseOutputStream((OutputStream)io.errorStream));
                channel.open();
                channel.waitFor(2, 0L);
            }
            finally {
                this.session.close(false);
            }
        }
        finally {
            client.stop();
        }
        io.verbose(messages.getMessage("verbose.disconnected"));
        return CommandAction.Result.SUCCESS;
    }

    private class UsernamePasswordValidator
    implements PromptReader.Validator {
        private String type;
        private int count = 0;
        private int max = 3;

        public UsernamePasswordValidator(String type) {
            assert (type != null);
            this.type = type;
        }

        public boolean isValid(String value) {
            ++this.count;
            if (value != null && value.trim().length() > 0) {
                return true;
            }
            if (this.count >= this.max) {
                throw new RuntimeException("Too many attempts; failed to prompt user for " + this.type + " after " + this.max + " tries");
            }
            return false;
        }
    }
}

