/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileObject;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.Closer;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.support.VfsActionSupport;

public class CatAction
extends VfsActionSupport {
    @Option(name="-n")
    private boolean displayLineNumbers;
    @Argument(required=true)
    private String path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        FileObject file = this.resolveFile(context, this.path);
        this.ensureFileExists(file);
        this.ensureFileHasContent(file);
        FileContent content = file.getContent();
        FileContentInfo info = content.getContentInfo();
        this.log.debug("Content type: {}", (Object)info.getContentType());
        this.log.debug("Content encoding: {}", (Object)info.getContentEncoding());
        this.log.debug("Displaying file: {}", (Object)file.getName());
        BufferedReader reader = new BufferedReader(new InputStreamReader(content.getInputStream()));
        try {
            this.cat(reader, io);
        }
        catch (Throwable throwable) {
            Closer.close(reader);
            throw throwable;
        }
        Closer.close(reader);
        FileObjects.close(file);
        return CommandAction.Result.SUCCESS;
    }

    private void cat(BufferedReader reader, IO io) throws IOException {
        String line;
        int lineno = 1;
        while ((line = reader.readLine()) != null) {
            if (this.displayLineNumbers) {
                io.out.print(String.format("%6d  ", lineno++));
            }
            io.out.println(line);
        }
    }
}

