/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import jline.CandidateListCompletionHandler;
import jline.CompletionHandler;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import org.apache.geronimo.gshell.console.Console;
import org.apache.geronimo.gshell.io.IO;

public class JLineConsole
extends Console {
    private final ConsoleReader reader;

    public JLineConsole(Console.Executor executor, IO io) throws IOException {
        super(executor);
        assert (io != null);
        this.reader = new ConsoleReader(io.inputStream, (Writer)new PrintWriter(io.outputStream, true), null, io.getTerminal());
        this.reader.setUsePagination(true);
        if (Boolean.getBoolean("jline.nobell")) {
            this.reader.setBellEnabled(false);
        }
        this.reader.setCompletionHandler((CompletionHandler)new CandidateListCompletionHandler());
    }

    public void addCompleter(Completor completer) {
        assert (completer != null);
        this.reader.addCompletor(completer);
    }

    public void setHistory(History history) {
        assert (history != null);
        this.reader.setHistory(history);
    }

    protected String readLine(String prompt) throws IOException {
        return this.reader.readLine(prompt);
    }
}

