/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.interpolation;

import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.interpolation.VariablesValueSource;
import org.apache.geronimo.gshell.notification.ErrorNotification;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableInterpolator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public String interpolate(String input, Variables vars) {
        String result;
        assert (input != null);
        assert (vars != null);
        if (input.indexOf(36) == -1) {
            return input;
        }
        Interpolator interp = this.createInterpolator(vars);
        this.log.trace("Interpolating: {}", (Object)input);
        try {
            result = interp.interpolate(input);
        }
        catch (InterpolationException e) {
            throw new ErrorNotification("Failed to interpolate expression: " + input, e);
        }
        this.log.trace("Iterpolated result: {}", (Object)result);
        return result;
    }

    private Interpolator createInterpolator(Variables vars) {
        assert (vars != null);
        RegexBasedInterpolator interp = new RegexBasedInterpolator();
        interp.addValueSource(new VariablesValueSource(vars));
        return interp;
    }
}

