/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.interpolation;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlExprResolver;
import org.apache.commons.jexl.resolver.FlatResolver;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.notification.ErrorNotification;
import org.codehaus.plexus.interpolation.AbstractValueSource;

public class VariablesValueSource
extends AbstractValueSource {
    private final FlatResolver resolver = new FlatResolver(true);
    private final JexlContext jexlContext = new JexlContext(){
        private final Map map;
        {
            this.map = new VariablesMapAdapter();
        }

        public Map getVars() {
            return this.map;
        }

        public void setVars(Map map) {
            throw new UnsupportedOperationException();
        }
    };
    private Variables variables;

    public VariablesValueSource(Variables vars) {
        super(false);
        if (vars != null) {
            this.setVariables(vars);
        }
    }

    public VariablesValueSource() {
        this(null);
    }

    public Variables getVariables() {
        return this.variables;
    }

    public void setVariables(Variables variables) {
        this.variables = variables;
    }

    public Object getValue(String input) {
        assert (input != null);
        if (this.variables == null) {
            throw new IllegalStateException("Variables have not yet been set");
        }
        try {
            Expression expr = ExpressionFactory.createExpression((String)input);
            expr.addPreResolver((JexlExprResolver)this.resolver);
            return expr.evaluate(this.jexlContext);
        }
        catch (Exception e) {
            throw new ErrorNotification("Failed to evaluate expression: " + input, e);
        }
    }

    private class VariablesMapAdapter
    implements Map {
        private VariablesMapAdapter() {
        }

        private String key(Object key) {
            return String.valueOf(key);
        }

        public Object get(Object key) {
            return VariablesValueSource.this.variables.get(this.key(key));
        }

        public Object put(Object key, Object value) {
            Object prev = VariablesValueSource.this.variables.get(this.key(key));
            VariablesValueSource.this.variables.set(this.key(key), value);
            return prev;
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

