/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import jline.ConsoleReader;
import jline.Terminal;
import org.apache.geronimo.gshell.ansi.AnsiRenderWriter;
import org.apache.geronimo.gshell.io.Closer;
import org.apache.geronimo.gshell.io.Flusher;
import org.apache.geronimo.gshell.yarn.Yarn;
import org.slf4j.helpers.MessageFormatter;

public class IO {
    public final InputStream inputStream;
    public final PrintStream outputStream;
    public final PrintStream errorStream;
    public final Reader in;
    public final PrintWriter out;
    public final PrintWriter err;
    private Verbosity verbosity = Verbosity.INFO;

    public IO(InputStream in, PrintStream out, PrintStream err, boolean autoFlush) {
        assert (in != null);
        assert (out != null);
        assert (err != null);
        this.inputStream = in;
        this.outputStream = out;
        this.errorStream = err;
        this.in = new InputStreamReader(in);
        this.out = new AnsiRenderWriter(this.outputStream, autoFlush);
        this.err = this.isSharedOutputStreams() ? this.out : new AnsiRenderWriter(this.errorStream, autoFlush);
    }

    public IO(InputStream in, OutputStream out, OutputStream err, boolean autoFlush) {
        this(in, new PrintStream(out, autoFlush), new PrintStream(err, autoFlush), autoFlush);
    }

    public IO(InputStream in, OutputStream out, boolean autoFlush) {
        this(in, new PrintStream(out, autoFlush), autoFlush);
    }

    public IO(InputStream in, PrintStream out, PrintStream err) {
        this(in, out, err, true);
    }

    public IO(InputStream in, PrintStream out, boolean autoFlush) {
        this(in, out, out, autoFlush);
    }

    public IO(InputStream in, PrintStream out) {
        this(in, out, out);
    }

    public IO() {
        this(System.in, System.out, System.err);
    }

    public String toString() {
        return Yarn.render(this);
    }

    public boolean isSharedOutputStreams() {
        return this.outputStream == this.errorStream;
    }

    public Terminal getTerminal() {
        return Terminal.getTerminal();
    }

    public void setVerbosity(Verbosity verbosity) {
        assert (verbosity != null);
        this.verbosity = verbosity;
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public boolean isSilent() {
        return this.verbosity == Verbosity.SILENT;
    }

    public boolean isQuiet() {
        return this.verbosity == Verbosity.QUIET;
    }

    public boolean isInfo() {
        return this.verbosity == Verbosity.INFO;
    }

    public boolean isVerbose() {
        return this.verbosity == Verbosity.VERBOSE;
    }

    public boolean isDebug() {
        return this.verbosity == Verbosity.DEBUG;
    }

    public void flush() {
        Flusher.flush(this.out);
        if (!this.isSharedOutputStreams()) {
            Flusher.flush(this.err);
        }
    }

    public void close() throws IOException {
        Closer.close(this.in, this.out);
        if (!this.isSharedOutputStreams()) {
            Closer.close(this.err);
        }
    }

    public void debug(String msg) {
        if (this.isDebug()) {
            this.out.println(msg);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.isDebug()) {
            this.out.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
        }
    }

    public void verbose(String msg) {
        if (this.isVerbose()) {
            this.out.println(msg);
        }
    }

    public void verbose(String format, Object ... args) {
        if (this.isVerbose()) {
            this.out.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
        }
    }

    public void info(String msg) {
        if (!this.isQuiet()) {
            this.out.println(msg);
        }
    }

    public void info(String format, Object ... args) {
        if (!this.isQuiet()) {
            this.out.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
        }
    }

    public void warn(String msg) {
        if (!this.isQuiet()) {
            this.err.println(msg);
        }
    }

    public void warn(String format, Object ... args) {
        if (!this.isQuiet()) {
            this.err.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
        }
    }

    public void error(String msg) {
        this.err.println(msg);
    }

    public void error(String format, Object ... args) {
        this.err.println(MessageFormatter.arrayFormat((String)format, (Object[])args));
    }

    public ConsoleReader createConsoleReader() throws IOException {
        return new ConsoleReader(this.inputStream, (Writer)new PrintWriter(this.outputStream, true), null, this.getTerminal());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Verbosity {
        SILENT,
        QUIET,
        INFO,
        VERBOSE,
        DEBUG;

    }
}

