/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import jline.ConsoleReader;
import org.apache.geronimo.gshell.io.IO;

public class PromptReader {
    private char mask = (char)42;
    private final ConsoleReader reader;

    public PromptReader(IO io) throws IOException {
        assert (io != null);
        this.reader = new ConsoleReader(io.inputStream, (Writer)new PrintWriter(io.outputStream, true), null, io.getTerminal());
    }

    public char getMask() {
        return this.mask;
    }

    public void setMask(char mask) {
        this.mask = mask;
    }

    public String readLine(String prompt, Validator validator) throws IOException {
        String value;
        assert (prompt != null);
        do {
            value = this.reader.readLine(prompt);
        } while (validator != null && !validator.isValid(value));
        return value;
    }

    public String readLine(String prompt) throws IOException {
        return this.readLine(prompt, null);
    }

    public String readLine(String prompt, char mask, Validator validator) throws IOException {
        String value;
        assert (prompt != null);
        do {
            value = this.reader.readLine(prompt, Character.valueOf(mask));
        } while (validator != null && !validator.isValid(value));
        return value;
    }

    public String readLine(String prompt, char mask) throws IOException {
        return this.readLine(prompt, mask, null);
    }

    public String readPassword(String prompt, Validator validator) throws IOException {
        String value;
        assert (prompt != null);
        do {
            value = this.reader.readLine(prompt, Character.valueOf(this.mask));
        } while (validator != null && !validator.isValid(value));
        return value;
    }

    public String readPassword(String prompt) throws IOException {
        return this.readPassword(prompt, null);
    }

    public static interface Validator {
        public boolean isValid(String var1);
    }
}

