/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geronimo.gshell.io.Closer;

public class StreamPumper
implements Runnable {
    private InputStream in;
    private OutputStream out;
    private volatile boolean finish;
    private volatile boolean finished;
    private boolean closeWhenExhausted;
    private boolean autoflush;
    private Exception exception;
    private int bufferSize = 128;
    private boolean started;

    public StreamPumper(InputStream in, OutputStream out, boolean closeWhenExhausted) {
        assert (in != null);
        assert (out != null);
        this.in = in;
        this.out = out;
        this.closeWhenExhausted = closeWhenExhausted;
    }

    public StreamPumper(InputStream in, OutputStream out) {
        this(in, out, false);
    }

    public void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block21: {
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.started = true;
            }
            this.finished = false;
            this.finish = false;
            byte[] buf = new byte[this.bufferSize];
            try {
                int length;
                while ((length = this.in.read(buf)) > 0 && !this.finish) {
                    this.out.write(buf, 0, length);
                    if (!this.autoflush) continue;
                    this.out.flush();
                }
                this.out.flush();
                if (!this.closeWhenExhausted) break block21;
            }
            catch (Exception e) {
                block22: {
                    try {
                        StreamPumper streamPumper2 = this;
                        synchronized (streamPumper2) {
                            this.exception = e;
                        }
                        if (!this.closeWhenExhausted) break block22;
                    }
                    catch (Throwable throwable) {
                        if (this.closeWhenExhausted) {
                            Closer.close(this.out);
                        }
                        this.finished = true;
                        StreamPumper streamPumper3 = this;
                        synchronized (streamPumper3) {
                            this.notifyAll();
                        }
                        throw throwable;
                    }
                    Closer.close(this.out);
                }
                this.finished = true;
                StreamPumper streamPumper4 = this;
                synchronized (streamPumper4) {
                    this.notifyAll();
                }
            }
            Closer.close(this.out);
        }
        this.finished = true;
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }

    public synchronized void setBufferSize(int bufferSize) {
        if (this.started) {
            throw new IllegalStateException("Cannot set buffer size on a running StreamPumper");
        }
        this.bufferSize = bufferSize;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    public synchronized void stop() {
        this.finish = true;
        this.notifyAll();
    }
}

