/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.geronimo.gshell.io.StreamPair;

public class SystemOutputHijacker {
    private static final InheritableThreadLocal<StreamRegistration> registrations = new InheritableThreadLocal();
    private static StreamPair previous;
    private static boolean installed;

    public static synchronized boolean isInstalled() {
        return installed;
    }

    private static synchronized void ensureInstalled() {
        if (!SystemOutputHijacker.isInstalled()) {
            throw new IllegalStateException("Not installed");
        }
    }

    public static synchronized void install() {
        if (installed) {
            throw new IllegalStateException("Already installed");
        }
        previous = new StreamPair(System.out, System.err);
        System.setOut(new DelegateStream(StreamPair.Type.OUT));
        System.setErr(new DelegateStream(StreamPair.Type.ERR));
        installed = true;
    }

    public static synchronized void install(PrintStream out, PrintStream err) {
        SystemOutputHijacker.install();
        SystemOutputHijacker.register(out, err);
    }

    public static synchronized void install(PrintStream out) {
        SystemOutputHijacker.install();
        SystemOutputHijacker.register(out);
    }

    public static synchronized void install(StreamPair pair) {
        SystemOutputHijacker.install();
        SystemOutputHijacker.register(pair);
    }

    public static synchronized void uninstall() {
        SystemOutputHijacker.ensureInstalled();
        System.setOut(SystemOutputHijacker.previous.out);
        System.setErr(SystemOutputHijacker.previous.err);
        previous = null;
        installed = false;
    }

    private static synchronized StreamRegistration registration(boolean required) {
        if (required) {
            SystemOutputHijacker.ensureRegistered();
        }
        return (StreamRegistration)registrations.get();
    }

    public static synchronized boolean isRegistered() {
        return SystemOutputHijacker.registration(false) != null;
    }

    private static synchronized void ensureRegistered() {
        SystemOutputHijacker.ensureInstalled();
        if (!SystemOutputHijacker.isRegistered()) {
            throw new IllegalStateException("Streams not registered for thread: " + Thread.currentThread());
        }
    }

    public static synchronized void register(PrintStream out, PrintStream err) {
        SystemOutputHijacker.ensureInstalled();
        StreamRegistration prev = SystemOutputHijacker.registration(false);
        StreamPair pair = new StreamPair(out, err);
        StreamRegistration next = new StreamRegistration(pair, prev);
        registrations.set(next);
    }

    public static synchronized void register(PrintStream out) {
        SystemOutputHijacker.register(out, out);
    }

    public static synchronized void register(StreamPair pair) {
        assert (pair != null);
        SystemOutputHijacker.register(pair.out, pair.err);
    }

    public static synchronized void deregister() {
        StreamRegistration cur = SystemOutputHijacker.registration(true);
        registrations.set(cur.previous);
    }

    private static synchronized StreamPair current() {
        StreamRegistration reg = SystemOutputHijacker.registration(false);
        if (reg == null) {
            return previous;
        }
        return reg.streams;
    }

    public static synchronized void restore(StreamPair streams) {
        assert (streams != null);
        StreamPair.system(streams);
        previous = null;
        installed = false;
    }

    public static synchronized void restore() {
        SystemOutputHijacker.restore(StreamPair.SYSTEM);
    }

    private static class DelegateStream
    extends PrintStream {
        private static final ByteArrayOutputStream NULL_OUTPUT = new ByteArrayOutputStream();
        private final StreamPair.Type type;

        public DelegateStream(StreamPair.Type type) {
            super(NULL_OUTPUT);
            assert (type != null);
            this.type = type;
        }

        private PrintStream get() {
            return SystemOutputHijacker.current().get(this.type);
        }

        public void write(int b) {
            this.get().write(b);
        }

        public void write(byte[] b) throws IOException {
            this.get().write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) {
            this.get().write(b, off, len);
        }

        public void flush() {
            this.get().flush();
        }

        public void close() {
            this.get().close();
        }
    }

    private static class StreamRegistration {
        public final StreamPair streams;
        public final StreamRegistration previous;

        public StreamRegistration(StreamPair streams, StreamRegistration previous) {
            assert (streams != null);
            this.streams = streams;
            this.previous = previous;
        }
    }
}

