/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.parser.visitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geronimo.gshell.command.Arguments;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.commandline.CommandLineExecutionFailed;
import org.apache.geronimo.gshell.commandline.CommandLineExecutor;
import org.apache.geronimo.gshell.interpolation.VariableInterpolator;
import org.apache.geronimo.gshell.io.Closer;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.notification.ErrorNotification;
import org.apache.geronimo.gshell.notification.Notification;
import org.apache.geronimo.gshell.parser.ASTCommandLine;
import org.apache.geronimo.gshell.parser.ASTExpression;
import org.apache.geronimo.gshell.parser.ASTOpaqueString;
import org.apache.geronimo.gshell.parser.ASTPlainString;
import org.apache.geronimo.gshell.parser.ASTProcess;
import org.apache.geronimo.gshell.parser.ASTQuotedString;
import org.apache.geronimo.gshell.parser.CommandLineParserVisitor;
import org.apache.geronimo.gshell.parser.SimpleNode;
import org.apache.geronimo.gshell.shell.Shell;
import org.apache.geronimo.gshell.shell.ShellContext;

public class ExecutingVisitor
implements CommandLineParserVisitor {
    private final ShellContext context;
    private final CommandLineExecutor executor;
    private final VariableInterpolator interp = new VariableInterpolator();

    public ExecutingVisitor(ShellContext context, CommandLineExecutor executor) {
        assert (context != null);
        assert (executor != null);
        this.context = context;
        this.executor = executor;
    }

    public Object visit(SimpleNode node, Object data) {
        assert (node != null);
        throw new Error("Unhandled node type: " + node.getClass().getName());
    }

    public Object visit(ASTCommandLine node, Object data) {
        assert (node != null);
        return node.childrenAccept(this, data);
    }

    public Object visit(ASTExpression node, Object data) {
        assert (node != null);
        Object[][] commands = new Object[node.jjtGetNumChildren()][];
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASTProcess proc = (ASTProcess)node.jjtGetChild(i);
            ArrayList list = new ArrayList(proc.jjtGetNumChildren());
            proc.childrenAccept(this, list);
            commands[i] = list.toArray(new Object[list.size()]);
            assert (list.size() >= 1);
        }
        try {
            return this.executePiped(commands);
        }
        catch (Exception e) {
            String s = Arguments.asString(commands[0]);
            for (int i = 1; i < commands.length; ++i) {
                s = s + " | " + Arguments.asString(commands[i]);
            }
            throw new ErrorNotification("Shell execution failed; commands=" + s, e);
        }
    }

    public Object visit(ASTProcess node, Object data) {
        return null;
    }

    private Object appendString(String value, Object data) {
        assert (data != null);
        assert (data instanceof List);
        List args = (List)data;
        args.add(value);
        return value;
    }

    public Object visit(ASTQuotedString node, Object data) {
        assert (node != null);
        String value = this.interp.interpolate(node.getValue(), this.context.getVariables());
        return this.appendString(value, data);
    }

    public Object visit(ASTPlainString node, Object data) {
        assert (node != null);
        String value = this.interp.interpolate(node.getValue(), this.context.getVariables());
        return this.appendString(value, data);
    }

    public Object visit(ASTOpaqueString node, Object data) {
        assert (node != null);
        return this.appendString(node.getValue(), data);
    }

    protected Thread createThread(Runnable task) {
        return new Thread(task);
    }

    private Object executePiped(final Object[][] commands) throws CommandLineExecutionFailed, InterruptedException, IOException {
        assert (commands != null);
        final IO[] ios = new IO[commands.length];
        PipedOutputStream pos = null;
        IO io = this.context.getIo();
        for (int i = 0; i < ios.length; ++i) {
            OutputStream os;
            InputStream is;
            InputStream inputStream = is = i == 0 ? io.inputStream : new PipedInputStream(pos);
            if (i == ios.length - 1) {
                os = io.outputStream;
            } else {
                pos = new PipedOutputStream();
                os = pos;
            }
            ios[i] = new IO(is, new PrintStream(os), io.errorStream);
        }
        final CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        final AtomicReference ref = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(commands.length);
        for (int i = 0; i < commands.length; ++i) {
            final int idx = i;
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block9: {
                        try {
                            ShellContext pipedContext = new ShellContext(){

                                public Shell getShell() {
                                    return ExecutingVisitor.this.context.getShell();
                                }

                                public IO getIo() {
                                    return ios[idx];
                                }

                                public Variables getVariables() {
                                    return ExecutingVisitor.this.context.getVariables();
                                }
                            };
                            Object obj = ExecutingVisitor.this.executor.execute(pipedContext, String.valueOf(commands[idx][0]), Arguments.shift(commands[idx]));
                            if (idx == commands.length - 1) {
                                ref.set(obj);
                            }
                            if (idx <= 0) break block9;
                        }
                        catch (Throwable t) {
                            block10: {
                                try {
                                    errors.add(t);
                                    if (idx <= 0) break block10;
                                }
                                catch (Throwable throwable) {
                                    if (idx > 0) {
                                        Closer.close(ios[idx].inputStream);
                                    }
                                    if (idx < commands.length - 1) {
                                        Closer.close(ios[idx].outputStream);
                                    }
                                    latch.countDown();
                                    throw throwable;
                                }
                                Closer.close(ios[idx].inputStream);
                            }
                            if (idx < commands.length - 1) {
                                Closer.close(ios[idx].outputStream);
                            }
                            latch.countDown();
                        }
                        Closer.close(ios[idx].inputStream);
                    }
                    if (idx < commands.length - 1) {
                        Closer.close(ios[idx].outputStream);
                    }
                    latch.countDown();
                }
            };
            if (idx != commands.length - 1) {
                this.createThread(r).start();
                continue;
            }
            r.run();
        }
        latch.await();
        if (!errors.isEmpty()) {
            Throwable t = (Throwable)errors.get(0);
            if (t instanceof Notification) {
                throw (Notification)t;
            }
            throw new CommandLineExecutionFailed(t);
        }
        return ref.get();
    }
}

