/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.parser.visitor;

import org.apache.geronimo.gshell.parser.ASTCommandLine;
import org.apache.geronimo.gshell.parser.ASTExpression;
import org.apache.geronimo.gshell.parser.ASTOpaqueString;
import org.apache.geronimo.gshell.parser.ASTPlainString;
import org.apache.geronimo.gshell.parser.ASTProcess;
import org.apache.geronimo.gshell.parser.ASTQuotedString;
import org.apache.geronimo.gshell.parser.CommandLineParserVisitor;
import org.apache.geronimo.gshell.parser.SimpleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingVisitor
implements CommandLineParserVisitor {
    private final Logger log;
    private final Level level;
    private int indent = 0;

    public LoggingVisitor() {
        this(LoggerFactory.getLogger(LoggingVisitor.class));
    }

    public LoggingVisitor(Logger log) {
        this(log, Level.DEBUG);
    }

    public LoggingVisitor(Logger log, Level level) {
        assert (log != null);
        assert (level != null);
        this.log = log;
        this.level = level;
    }

    private Object log(Class type, SimpleNode node, Object data) {
        switch (this.level) {
            case INFO: {
                if (this.log.isInfoEnabled()) break;
                return data;
            }
            case DEBUG: {
                if (this.log.isDebugEnabled()) break;
                return data;
            }
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            buff.append(" ");
        }
        buff.append(node).append(" (").append(type.getName()).append(")");
        if (data != null) {
            buff.append("; Data: ").append(data);
        }
        switch (this.level) {
            case INFO: {
                this.log.info(buff.toString());
                break;
            }
            case DEBUG: {
                this.log.debug(buff.toString());
            }
        }
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(SimpleNode node, Object data) {
        return this.log(SimpleNode.class, node, data);
    }

    public Object visit(ASTCommandLine node, Object data) {
        return this.log(ASTCommandLine.class, node, data);
    }

    public Object visit(ASTExpression node, Object data) {
        return this.log(ASTExpression.class, node, data);
    }

    public Object visit(ASTProcess node, Object data) {
        return this.log(ASTProcess.class, node, data);
    }

    public Object visit(ASTQuotedString node, Object data) {
        return this.log(ASTQuotedString.class, node, data);
    }

    public Object visit(ASTOpaqueString node, Object data) {
        return this.log(ASTOpaqueString.class, node, data);
    }

    public Object visit(ASTPlainString node, Object data) {
        return this.log(ASTPlainString.class, node, data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        INFO,
        DEBUG;

    }
}

