/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.shell;

import org.apache.geronimo.gshell.shell.ShellContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellContextHolder {
    private static final Logger log = LoggerFactory.getLogger(ShellContextHolder.class);
    private static final InheritableThreadLocal<ShellContext> holder = new InheritableThreadLocal();

    public static void set(ShellContext context) {
        log.trace("Setting context: {}", (Object)context);
        holder.set(context);
    }

    public static ShellContext get(boolean allowNull) {
        ShellContext context = (ShellContext)holder.get();
        log.trace("Getting context ({}): {}", (Object)allowNull, (Object)context);
        if (!allowNull && context == null) {
            throw new IllegalStateException("Shell context not initialized for thread: " + Thread.currentThread());
        }
        return context;
    }

    public static ShellContext get() {
        return ShellContextHolder.get(false);
    }
}

