/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geronimo.gshell.spring.BeanContainerContext;
import org.apache.geronimo.gshell.spring.BeanContainerContextException;
import org.apache.geronimo.gshell.spring.BeanContainerContextSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;

public class BeanContainerContextImpl
extends BeanContainerContextSupport {
    private final Set<Resource> resources = new LinkedHashSet<Resource>();

    public BeanContainerContextImpl(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public BeanContainerContextImpl(ClassLoader classLoader, BeanContainerContextImpl parent) {
        super(parent);
        assert (classLoader != null);
        this.setClassLoader(classLoader);
    }

    public void configure(String[] locations) {
        assert (locations != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Configuring with locations: {}", Arrays.asList(locations));
        }
        for (String location : locations) {
            Resource[] resources;
            try {
                resources = this.getResources(location);
            }
            catch (IOException e) {
                throw new BeanContainerContextException("Failed to load resources from location: " + location, e);
            }
            BeanContainerContext parent = this.getParent();
            if (parent instanceof BeanContainerContextImpl) {
                resources = ((BeanContainerContextImpl)parent).filterOwnedResources(resources);
            }
            this.resources.addAll(Arrays.asList(resources));
        }
        this.log.debug("Configured {} resources", (Object)this.resources.size());
    }

    private Resource[] filterOwnedResources(Resource[] resources) {
        assert (resources != null);
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource resource : resources) {
            if (this.resources.contains(resource)) {
                this.log.trace("Filtered owned resource: {}", (Object)resource);
                continue;
            }
            list.add(resource);
        }
        Resource[] filteredResources = list.toArray(new Resource[list.size()]);
        BeanContainerContext parent = this.getParent();
        if (parent instanceof BeanContainerContextImpl) {
            filteredResources = ((BeanContainerContextImpl)parent).filterOwnedResources(filteredResources);
        }
        return filteredResources;
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        assert (reader != null);
        this.log.debug("Loading bean definitions from resources");
        if (this.log.isTraceEnabled()) {
            for (Resource resource : this.resources) {
                this.log.trace("    {}", (Object)resource);
            }
        }
        reader.loadBeanDefinitions(this.resources.toArray(new Resource[this.resources.size()]));
    }

    public void addBeanPostProcessor(final BeanPostProcessor processor) {
        assert (processor != null);
        this.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                assert (beanFactory != null);
                if (processor instanceof BeanFactoryAware) {
                    ((BeanFactoryAware)processor).setBeanFactory((BeanFactory)beanFactory);
                }
                beanFactory.addBeanPostProcessor(processor);
            }
        });
    }
}

