/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.geronimo.gshell.chronos.StopWatch;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.apache.geronimo.gshell.spring.BeanContainerAwareProcessor;
import org.apache.geronimo.gshell.spring.BeanContainerContext;
import org.apache.geronimo.gshell.spring.BeanContainerContextImpl;
import org.apache.geronimo.gshell.spring.LoggingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanContainerImpl
implements BeanContainer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader classLoader;
    private final BeanContainerImpl parent;
    private final BeanContainerContextImpl context;

    public BeanContainerImpl(ClassLoader cl) {
        this(cl, null);
    }

    private BeanContainerImpl(ClassLoader classLoader, BeanContainerImpl parent) {
        assert (classLoader != null);
        this.parent = parent;
        this.classLoader = classLoader;
        this.context = new BeanContainerContextImpl(classLoader, parent != null ? parent.context : null);
        this.context.addBeanPostProcessor(new BeanContainerAwareProcessor(this));
        this.context.addBeanFactoryPostProcessor(new LoggingProcessor());
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public BeanContainer getParent() {
        return this.parent;
    }

    public BeanContainerContext getContext() {
        return this.context;
    }

    @Override
    public void loadBeans(String[] locations) throws Exception {
        assert (locations != null);
        this.log.debug("Loading beans");
        StopWatch watch = new StopWatch(true);
        this.context.configure(locations);
        this.context.refresh();
        this.log.debug("Loaded beans after: {}", (Object)watch);
    }

    @Override
    public BeanContainer createChild(Collection<URL> classPath) {
        this.log.debug("Creating child container");
        if (this.log.isTraceEnabled() && classPath != null) {
            this.log.trace("Classpath:");
            for (URL url : classPath) {
                this.log.trace("    {}", (Object)url);
            }
        }
        URLClassLoader childLoader = classPath != null ? new URLClassLoader(classPath.toArray(new URL[classPath.size()]), this.classLoader) : new URLClassLoader(new URL[0], this.classLoader);
        return new BeanContainerImpl(childLoader, this);
    }

    @Override
    public BeanContainer createChild() {
        return this.createChild(null);
    }

    @Override
    public <T> T getBean(Class<T> type) {
        assert (type != null);
        this.log.trace("Getting bean of type: {}", type);
        String[] names = this.getContext().getBeanNamesForType(type);
        if (names.length == 0) {
            throw new NoSuchBeanDefinitionException(type, "No bean defined for type: " + type);
        }
        if (names.length > 1) {
            throw new NoSuchBeanDefinitionException(type, "No unique bean defined for type: " + type + ", found matches: " + Arrays.asList(names));
        }
        return this.getBean(names[0], type);
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) {
        assert (name != null);
        assert (requiredType != null);
        this.log.trace("Getting bean named '{}' of type: {}", (Object)name, requiredType);
        return (T)this.getContext().getBean(name, requiredType);
    }

    @Override
    public <T> Map<String, T> getBeans(Class<T> type) {
        assert (type != null);
        this.log.trace("Getting beans of type: {}", type);
        return this.getContext().getBeansOfType(type);
    }

    @Override
    public String[] getBeanNames() {
        this.log.trace("Getting bean names");
        return this.getContext().getBeanDefinitionNames();
    }

    @Override
    public String[] getBeanNames(Class type) {
        assert (type != null);
        this.log.trace("Getting bean names of type: {}", (Object)type);
        return this.getContext().getBeanNamesForType(type);
    }
}

