/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.terminal;

import java.io.IOException;
import java.io.InputStream;
import jline.ConsoleReader;
import jline.Terminal;
import org.apache.geronimo.gshell.terminal.UnixTerminal;
import org.apache.geronimo.gshell.terminal.WindowsTerminal;

public class AutoDetectedTerminal
extends Terminal {
    private final Terminal terminal;

    public AutoDetectedTerminal() {
        String os = System.getProperty("os.name").toLowerCase();
        this.terminal = os.indexOf("windows") != -1 ? new WindowsTerminal() : new UnixTerminal();
    }

    public boolean isANSISupported() {
        return this.terminal.isANSISupported();
    }

    public int readCharacter(InputStream in) throws IOException {
        return this.terminal.readCharacter(in);
    }

    public int readVirtualKey(InputStream in) throws IOException {
        return this.terminal.readVirtualKey(in);
    }

    public void initializeTerminal() throws Exception {
        this.terminal.initializeTerminal();
    }

    public int getTerminalWidth() {
        return this.terminal.getTerminalWidth();
    }

    public int getTerminalHeight() {
        return this.terminal.getTerminalHeight();
    }

    public boolean isSupported() {
        return this.terminal.isSupported();
    }

    public boolean getEcho() {
        return this.terminal.getEcho();
    }

    public void beforeReadLine(ConsoleReader reader, String prompt, Character mask) {
        this.terminal.beforeReadLine(reader, prompt, mask);
    }

    public void afterReadLine(ConsoleReader reader, String prompt, Character mask) {
        this.terminal.afterReadLine(reader, prompt, mask);
    }

    public boolean isEchoEnabled() {
        return this.terminal.isEchoEnabled();
    }

    public void enableEcho() {
        this.terminal.enableEcho();
    }

    public void disableEcho() {
        this.terminal.disableEcho();
    }

    public InputStream getDefaultBindings() {
        return this.terminal.getDefaultBindings();
    }
}

