/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileObjects {
    private static final Logger log = LoggerFactory.getLogger(FileObjects.class);

    public static boolean hasChildren(FileObject file) throws FileSystemException {
        FileObject[] children;
        assert (file != null);
        return file.getType().hasChildren() && (children = file.getChildren()) != null && children.length != 0;
    }

    public static void close(FileObject file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (FileSystemException e) {
                log.trace("Failed to close file: " + file, (Throwable)e);
            }
        }
    }

    public static void closeAll(FileObject ... files) {
        if (files != null && files.length != 0) {
            for (FileObject file : files) {
                FileObjects.close(file);
            }
        }
    }
}

