/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.operations.FileOperationProvider;
import org.apache.geronimo.gshell.vfs.config.ConfigurableFileSystemManager;
import org.apache.geronimo.gshell.vfs.config.FileSystemManagerConfigurerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOperationProviderConfigurer
extends FileSystemManagerConfigurerSupport {
    private FileOperationProvider provider;
    private List<String> schemes;

    public void setProvider(FileOperationProvider provider) {
        this.provider = provider;
    }

    public void setSchemes(List<String> schemes) {
        this.schemes = schemes;
    }

    public void setScheme(String scheme) {
        this.schemes = new ArrayList<String>(1);
        this.schemes.add(scheme);
    }

    public void init() throws FileSystemException {
        this.log.debug("Adding file operation provider: {} -> {}", this.schemes, (Object)this.provider);
        ConfigurableFileSystemManager fsm = this.getFileSystemManager();
        for (String scheme : this.schemes) {
            if (!fsm.hasProvider(scheme)) continue;
            fsm.addOperationProvider(scheme, this.provider);
        }
    }
}

