/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs.config;

import org.apache.commons.vfs.CacheStrategy;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FilesCache;
import org.apache.commons.vfs.cache.SoftRefFilesCache;
import org.apache.commons.vfs.impl.DefaultFileReplicator;
import org.apache.commons.vfs.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs.impl.PrivilegedFileReplicator;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.FileReplicator;
import org.apache.commons.vfs.provider.TemporaryFileStore;
import org.apache.commons.vfs.provider.url.UrlFileProvider;
import org.apache.geronimo.gshell.vfs.config.ConfigurableFileSystemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class FileSystemManagerFactoryBean
implements FactoryBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private FilesCache filesCache;
    private CacheStrategy cacheStrategy = CacheStrategy.ON_RESOLVE;
    private FileReplicator fileReplicator;
    private TemporaryFileStore temporaryFileStore;
    private FileContentInfoFactory fileContentInfoFactory;
    private FileProvider defaultProvider;

    public void setFilesCache(FilesCache cache) {
        this.filesCache = cache;
    }

    public void setCacheStrategy(CacheStrategy strategy) {
        this.cacheStrategy = strategy;
    }

    public void setFileReplicator(FileReplicator replicator) {
        this.fileReplicator = replicator;
    }

    public void setTemporaryFileStore(TemporaryFileStore store) {
        this.temporaryFileStore = store;
    }

    public void setFileContentInfoFactory(FileContentInfoFactory factory) {
        this.fileContentInfoFactory = factory;
    }

    public void setDefaultProvider(FileProvider provider) {
        this.defaultProvider = provider;
    }

    public void init() {
        if (this.filesCache == null) {
            this.filesCache = new SoftRefFilesCache();
        }
        if (this.fileReplicator == null || this.temporaryFileStore == null) {
            DefaultFileReplicator replicator = new DefaultFileReplicator();
            if (this.fileReplicator == null) {
                this.fileReplicator = new PrivilegedFileReplicator((FileReplicator)replicator);
            }
            if (this.temporaryFileStore == null) {
                this.temporaryFileStore = replicator;
            }
        }
        if (this.fileContentInfoFactory == null) {
            this.fileContentInfoFactory = new FileContentInfoFilenameFactory();
        }
        if (this.defaultProvider == null) {
            this.defaultProvider = new UrlFileProvider();
        }
    }

    public Object getObject() throws Exception {
        ConfigurableFileSystemManager fsm = new ConfigurableFileSystemManager();
        assert (this.fileReplicator != null);
        this.log.debug("File replicator: {}", (Object)this.fileReplicator);
        fsm.setReplicator(this.fileReplicator);
        assert (this.temporaryFileStore != null);
        this.log.debug("Temporary file store: {}", (Object)this.temporaryFileStore);
        fsm.setTemporaryFileStore(this.temporaryFileStore);
        assert (this.filesCache != null);
        this.log.debug("Files cache: {}", (Object)this.filesCache);
        fsm.setFilesCache(this.filesCache);
        assert (this.cacheStrategy != null);
        this.log.debug("Cache strategy: {}", (Object)this.cacheStrategy);
        fsm.setCacheStrategy(this.cacheStrategy);
        assert (this.fileContentInfoFactory != null);
        this.log.debug("File content info factory: {}", (Object)this.fileContentInfoFactory);
        fsm.setFileContentInfoFactory(this.fileContentInfoFactory);
        assert (this.defaultProvider != null);
        this.log.debug("Default provider: {}", (Object)this.defaultProvider);
        fsm.setDefaultProvider(this.defaultProvider);
        fsm.init();
        return fsm;
    }

    public Class getObjectType() {
        return ConfigurableFileSystemManager.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

